/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.impl.ServerCookie;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CookieImpl
implements ServerCookie {
    private final io.netty.handler.codec.http.cookie.Cookie nettyCookie;
    private boolean changed;
    private boolean fromUserAgent;
    private CookieSameSite sameSite;

    static Map<String, ServerCookie> extractCookies(CharSequence cookieHeader) {
        if (cookieHeader != null) {
            Set nettyCookies = ServerCookieDecoder.STRICT.decode(cookieHeader.toString());
            HashMap<String, ServerCookie> cookies = new HashMap<String, ServerCookie>(nettyCookies.size());
            for (io.netty.handler.codec.http.cookie.Cookie cookie : nettyCookies) {
                CookieImpl ourCookie = new CookieImpl(cookie);
                cookies.put(ourCookie.getName(), ourCookie);
            }
            return cookies;
        }
        return new HashMap<String, ServerCookie>(4);
    }

    static Cookie removeCookie(Map<String, ServerCookie> cookieMap, String name, boolean invalidate) {
        ServerCookie cookie = cookieMap.get(name);
        if (cookie != null) {
            if (invalidate && cookie.isFromUserAgent()) {
                cookie.setMaxAge(0L);
            } else {
                cookieMap.remove(name);
            }
        }
        return cookie;
    }

    public CookieImpl(String name, String value) {
        this.nettyCookie = new DefaultCookie(name, value);
        this.changed = true;
    }

    public CookieImpl(io.netty.handler.codec.http.cookie.Cookie nettyCookie) {
        this.nettyCookie = nettyCookie;
        this.fromUserAgent = true;
    }

    @Override
    public String getValue() {
        return this.nettyCookie.value();
    }

    @Override
    public Cookie setValue(String value) {
        this.nettyCookie.setValue(value);
        this.changed = true;
        return this;
    }

    @Override
    public String getName() {
        return this.nettyCookie.name();
    }

    @Override
    public Cookie setDomain(String domain) {
        this.nettyCookie.setDomain(domain);
        this.changed = true;
        return this;
    }

    @Override
    public String getDomain() {
        return this.nettyCookie.domain();
    }

    @Override
    public Cookie setPath(String path) {
        this.nettyCookie.setPath(path);
        this.changed = true;
        return this;
    }

    @Override
    public String getPath() {
        return this.nettyCookie.path();
    }

    @Override
    public Cookie setMaxAge(long maxAge) {
        this.nettyCookie.setMaxAge(maxAge);
        this.changed = true;
        return this;
    }

    @Override
    public Cookie setSecure(boolean secure) {
        this.nettyCookie.setSecure(secure);
        this.changed = true;
        return this;
    }

    @Override
    public Cookie setHttpOnly(boolean httpOnly) {
        this.nettyCookie.setHttpOnly(httpOnly);
        this.changed = true;
        return this;
    }

    @Override
    public Cookie setSameSite(CookieSameSite sameSite) {
        this.sameSite = sameSite;
        this.changed = true;
        return this;
    }

    @Override
    public String encode() {
        if (this.sameSite != null) {
            return ServerCookieEncoder.STRICT.encode(this.nettyCookie) + "; SameSite=" + this.sameSite.toString();
        }
        return ServerCookieEncoder.STRICT.encode(this.nettyCookie);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public boolean isFromUserAgent() {
        return this.fromUserAgent;
    }
}

