/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.pkcs1.PrivateKeyParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class KeyStoreHelper {
    public static final String DUMMY_PASSWORD = "dummy";
    private static final String DUMMY_CERT_ALIAS = "cert-";
    private static final Pattern BEGIN_PATTERN = Pattern.compile("-----BEGIN ([A-Z ]+)-----");
    private static final Pattern END_PATTERN = Pattern.compile("-----END ([A-Z ]+)-----");
    private final String password;
    private final KeyStore store;
    private final String aliasPassword;
    private final Map<String, X509KeyManager> wildcardMgrMap = new HashMap<String, X509KeyManager>();
    private final Map<String, X509KeyManager> mgrMap = new HashMap<String, X509KeyManager>();
    private final Map<String, TrustManagerFactory> trustMgrMap = new HashMap<String, TrustManagerFactory>();

    public KeyStoreHelper(KeyStore ks, String password, String aliasPassword) throws Exception {
        Enumeration<String> en = ks.aliases();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (ks.isCertificateEntry(alias) && !alias.startsWith(DUMMY_CERT_ALIAS)) {
                KeyStore keyStore = KeyStoreHelper.createEmptyKeyStore();
                keyStore.setCertificateEntry("cert-1", cert);
                TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                fact.init(keyStore);
                this.trustMgrMap.put(alias, fact);
            }
            if (!ks.isKeyEntry(alias) || !(cert instanceof X509Certificate)) continue;
            X509Certificate x509Cert = (X509Certificate)cert;
            Collection<List<?>> ans = x509Cert.getSubjectAlternativeNames();
            ArrayList<String> domains = new ArrayList<String>();
            if (ans != null) {
                for (List<?> l : ans) {
                    if (l.size() != 2 || !(l.get(0) instanceof Number) || ((Number)l.get(0)).intValue() != 2) continue;
                    String dns = l.get(1).toString();
                    domains.add(dns);
                }
            }
            String dn = x509Cert.getSubjectX500Principal().getName();
            domains.addAll(KeyStoreHelper.getX509CertificateCommonNames(dn));
            if (domains.isEmpty()) continue;
            char[] keyPassword = this.keyPassword(aliasPassword, password);
            final PrivateKey key = (PrivateKey)ks.getKey(alias, keyPassword);
            final Certificate[] tmp = ks.getCertificateChain(alias);
            if (tmp == null) continue;
            X509KeyManager mgr = new X509KeyManager(){

                @Override
                public String[] getClientAliases(String s, Principal[] principals) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String[] getServerAliases(String s, Principal[] principals) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public X509Certificate[] getCertificateChain(String s) {
                    return (X509Certificate[])Arrays.stream(tmp).map(X509Certificate.class::cast).toArray(X509Certificate[]::new);
                }

                @Override
                public PrivateKey getPrivateKey(String s) {
                    return key;
                }
            };
            for (String domain : domains) {
                if (domain.startsWith("*.")) {
                    this.wildcardMgrMap.put(domain.substring(2), mgr);
                    continue;
                }
                this.mgrMap.put(domain, mgr);
            }
        }
        this.store = ks;
        this.password = password;
        this.aliasPassword = aliasPassword;
    }

    public KeyManagerFactory getKeyMgrFactory() throws Exception {
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] keyPassword = this.keyPassword(this.aliasPassword, this.password);
        fact.init(this.store, keyPassword);
        return fact;
    }

    private char[] keyPassword(String aliasPassword, String password) {
        if (aliasPassword != null) {
            return aliasPassword.toCharArray();
        }
        return password != null ? password.toCharArray() : null;
    }

    public X509KeyManager getKeyMgr(String serverName) {
        int index;
        X509KeyManager mgr = this.mgrMap.get(serverName);
        if (mgr == null && !this.wildcardMgrMap.isEmpty() && (index = serverName.indexOf(46) + 1) > 0) {
            String s = serverName.substring(index);
            mgr = this.wildcardMgrMap.get(s);
        }
        return mgr;
    }

    public KeyManager[] getKeyMgr() throws Exception {
        return this.getKeyMgrFactory().getKeyManagers();
    }

    public TrustManager[] getTrustMgr(String serverName) {
        TrustManagerFactory fact = this.trustMgrMap.get(serverName);
        return fact != null ? fact.getTrustManagers() : null;
    }

    public TrustManagerFactory getTrustMgrFactory(VertxInternal vertx) throws Exception {
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        fact.init(this.store);
        return fact;
    }

    public TrustManager[] getTrustMgrs(VertxInternal vertx) throws Exception {
        return this.getTrustMgrFactory(vertx).getTrustManagers();
    }

    public KeyStore store() {
        return this.store;
    }

    public static List<String> getX509CertificateCommonNames(String dn) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        if (!PlatformDependent.isAndroid()) {
            LdapName ldapDN = new LdapName(dn);
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                String name = rdn.getValue().toString();
                names.add(name);
            }
        } else {
            String[] rdns;
            for (String rdn : rdns = dn.trim().split("[,;]")) {
                String[] nvp = rdn.trim().split("=");
                if (nvp.length != 2 || !"cn".equalsIgnoreCase(nvp[0])) continue;
                names.add(nvp[1]);
            }
        }
        return names;
    }

    public static KeyStore loadKeyStore(String type, String provider, String password, Supplier<Buffer> value, String alias) throws Exception {
        Objects.requireNonNull(type);
        KeyStore ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        ByteArrayInputStream in = new ByteArrayInputStream(value.get().getBytes());
        Object object = null;
        try {
            ks.load(in, password != null ? password.toCharArray() : null);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)in).close();
                }
            }
        }
        if (alias != null) {
            if (!ks.containsAlias(alias)) {
                throw new IllegalArgumentException("alias does not exist in the keystore: " + alias);
            }
            ArrayList<String> ksAliases = Collections.list(ks.aliases());
            for (String ksAlias : ksAliases) {
                if (alias.equals(ksAlias)) continue;
                ks.deleteEntry(ksAlias);
            }
        }
        return ks;
    }

    public static KeyStore loadKeyCert(List<Buffer> keyValue, List<Buffer> certValue) throws Exception {
        if (keyValue.size() < certValue.size()) {
            throw new VertxException("Missing private key");
        }
        if (keyValue.size() > certValue.size()) {
            throw new VertxException("Missing X.509 certificate");
        }
        KeyStore keyStore = KeyStoreHelper.createEmptyKeyStore();
        Iterator<Buffer> keyValueIt = keyValue.iterator();
        Iterator<Buffer> certValueIt = certValue.iterator();
        int index = 0;
        while (keyValueIt.hasNext() && certValueIt.hasNext()) {
            PrivateKey key = KeyStoreHelper.loadPrivateKey(keyValueIt.next());
            Certificate[] chain = KeyStoreHelper.loadCerts(certValueIt.next());
            keyStore.setEntry("dummy-entry-" + index++, new KeyStore.PrivateKeyEntry(key, chain), new KeyStore.PasswordProtection(DUMMY_PASSWORD.toCharArray()));
        }
        return keyStore;
    }

    private static PrivateKey loadPrivateKey(Buffer keyValue) throws Exception {
        KeyFactory ecKeyFactory;
        if (keyValue == null) {
            throw new RuntimeException("Missing private key path");
        }
        KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
        List pems = KeyStoreHelper.loadPems(keyValue, (arg_0, arg_1) -> KeyStoreHelper.lambda$loadPrivateKey$0(rsaKeyFactory, ecKeyFactory = KeyStoreHelper.getECKeyFactory(), arg_0, arg_1));
        if (pems.isEmpty()) {
            throw new RuntimeException("Missing -----BEGIN PRIVATE KEY----- or -----BEGIN RSA PRIVATE KEY----- delimiter");
        }
        return (PrivateKey)pems.get(0);
    }

    private static KeyFactory getECKeyFactory() {
        try {
            return KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static KeyStore loadCA(Stream<Buffer> certValues) throws Exception {
        KeyStore keyStore = KeyStoreHelper.createEmptyKeyStore();
        keyStore.load(null, null);
        int count = 0;
        Iterable iterable = certValues::iterator;
        for (Buffer certValue : iterable) {
            for (X509Certificate cert : KeyStoreHelper.loadCerts(certValue)) {
                keyStore.setCertificateEntry(DUMMY_CERT_ALIAS + count++, cert);
            }
        }
        return keyStore;
    }

    private static <P> List<P> loadPems(Buffer data, BiFunction<String, byte[], Collection<P>> pemFact) throws IOException {
        boolean begin;
        String pem = data.toString();
        ArrayList<P> pems = new ArrayList<P>();
        Matcher beginMatcher = BEGIN_PATTERN.matcher(pem);
        Matcher endMatcher = END_PATTERN.matcher(pem);
        while (begin = beginMatcher.find()) {
            String beginDelimiter = beginMatcher.group(1);
            boolean end = endMatcher.find();
            if (!end) {
                throw new RuntimeException("Missing -----END " + beginDelimiter + "----- delimiter");
            }
            String endDelimiter = endMatcher.group(1);
            if (!beginDelimiter.equals(endDelimiter)) {
                throw new RuntimeException("Missing -----END " + beginDelimiter + "----- delimiter");
            }
            String content = pem.substring(beginMatcher.end(), endMatcher.start());
            if ((content = content.replaceAll("\\s", "")).length() == 0) {
                throw new RuntimeException("Empty pem file");
            }
            Collection<P> pemItems = pemFact.apply(endDelimiter, Base64.getDecoder().decode(content));
            pems.addAll(pemItems);
        }
        return pems;
    }

    private static X509Certificate[] loadCerts(Buffer buffer) throws Exception {
        if (buffer == null) {
            throw new RuntimeException("Missing X.509 certificate path");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        List certs = KeyStoreHelper.loadPems(buffer, (delimiter, content) -> {
            try {
                switch (delimiter) {
                    case "CERTIFICATE": {
                        return certFactory.generateCertificates(new ByteArrayInputStream((byte[])content));
                    }
                }
                return Collections.emptyList();
            }
            catch (CertificateException e) {
                throw new VertxException(e);
            }
        });
        if (certs.isEmpty()) {
            throw new RuntimeException("Missing -----BEGIN CERTIFICATE----- delimiter");
        }
        return certs.toArray(new X509Certificate[0]);
    }

    private static KeyStore createEmptyKeyStore() throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try {
            keyStore.load(null, null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Failed to initialize the keystore", e);
        }
        return keyStore;
    }

    private static /* synthetic */ Collection lambda$loadPrivateKey$0(KeyFactory rsaKeyFactory, KeyFactory ecKeyFactory, String delimiter, byte[] content) {
        try {
            switch (delimiter) {
                case "RSA PRIVATE KEY": {
                    return Collections.singletonList(rsaKeyFactory.generatePrivate(PrivateKeyParser.getRSAKeySpec(content)));
                }
                case "PRIVATE KEY": {
                    String algorithm = PrivateKeyParser.getPKCS8EncodedKeyAlgorithm(content);
                    if (rsaKeyFactory.getAlgorithm().equals(algorithm)) {
                        return Collections.singletonList(rsaKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(content)));
                    }
                    if (ecKeyFactory == null || !ecKeyFactory.getAlgorithm().equals(algorithm)) break;
                    return Collections.singletonList(ecKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(content)));
                }
            }
            return Collections.emptyList();
        }
        catch (InvalidKeySpecException e) {
            throw new VertxException(e);
        }
    }
}

