/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft7;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.BaseSingleSchemaValidatorFactory;
import io.vertx.json.schema.common.JsonUtil;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class ContainsValidatorFactory
extends BaseSingleSchemaValidatorFactory {
    @Override
    protected BaseSingleSchemaValidator instantiate(MutableStateValidator parent) {
        return new ContainsValidator(parent);
    }

    @Override
    protected String getKeyword() {
        return "contains";
    }

    static class ContainsValidator
    extends BaseSingleSchemaValidator {
        public ContainsValidator(MutableStateValidator parent) {
            super(parent);
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            Object o = JsonUtil.unwrap(in);
            if (o instanceof List) {
                List arr = (List)o;
                if (arr.isEmpty()) {
                    return Future.failedFuture((Throwable)((Object)ValidationException.create("provided array should not be empty", "contains", in)));
                }
                ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
                for (int i = 0; i < arr.size(); ++i) {
                    futs.add(this.schema.validateAsync(context.lowerLevelContext(i), arr.get(i)));
                }
                return CompositeFuture.any(futs).compose(cf -> {
                    IntStream.rangeClosed(0, cf.size()).forEach(i -> {
                        if (cf.succeeded(i)) {
                            context.markEvaluatedItem(i);
                        }
                    });
                    return Future.succeededFuture();
                }, err -> Future.failedFuture((Throwable)((Object)ValidationException.create("provided array doesn't contain an element matching the contains schema", "contains", in, err))));
            }
            return Future.succeededFuture();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            ValidationException t = null;
            Object o = JsonUtil.unwrap(in);
            if (o instanceof List) {
                List arr = (List)o;
                for (int i = 0; i < arr.size(); ++i) {
                    try {
                        this.schema.validateSync(context.lowerLevelContext(i), arr.get(i));
                        context.markEvaluatedItem(i);
                        return;
                    }
                    catch (ValidationException e) {
                        t = e;
                        continue;
                    }
                }
                throw ValidationException.create("provided array doesn't contain an element matching the contains schema", "contains", in, (Throwable)((Object)t));
            }
        }
    }
}

