/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.junit5.Checkpoint;
import java.util.Objects;
import java.util.function.Consumer;

final class CountingCheckpoint
implements Checkpoint {
    private final Consumer<Checkpoint> satisfactionTrigger;
    private final Consumer<Throwable> overuseTrigger;
    private final int requiredNumberOfPasses;
    private int numberOfPasses = 0;
    private boolean satisfied = false;

    static CountingCheckpoint laxCountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, int requiredNumberOfPasses) {
        return new CountingCheckpoint(satisfactionTrigger, null, requiredNumberOfPasses);
    }

    static CountingCheckpoint strictCountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, Consumer<Throwable> overuseTrigger, int requiredNumberOfPasses) {
        Objects.requireNonNull(overuseTrigger);
        return new CountingCheckpoint(satisfactionTrigger, overuseTrigger, requiredNumberOfPasses);
    }

    private CountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, Consumer<Throwable> overuseTrigger, int requiredNumberOfPasses) {
        Objects.requireNonNull(satisfactionTrigger);
        if (requiredNumberOfPasses <= 0) {
            throw new IllegalArgumentException("A checkpoint needs at least 1 pass");
        }
        this.satisfactionTrigger = satisfactionTrigger;
        this.overuseTrigger = overuseTrigger;
        this.requiredNumberOfPasses = requiredNumberOfPasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flag() {
        boolean callSatisfactionTrigger = false;
        boolean callOveruseTrigger = false;
        CountingCheckpoint countingCheckpoint = this;
        synchronized (countingCheckpoint) {
            if (this.satisfied) {
                callOveruseTrigger = true;
            } else {
                ++this.numberOfPasses;
                if (this.numberOfPasses == this.requiredNumberOfPasses) {
                    callSatisfactionTrigger = true;
                    this.satisfied = true;
                }
            }
        }
        if (callSatisfactionTrigger) {
            this.satisfactionTrigger.accept(this);
        } else if (callOveruseTrigger && this.overuseTrigger != null) {
            this.overuseTrigger.accept(new IllegalStateException("Strict checkpoint flagged too many times"));
        }
    }
}

