/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.client.common.Node;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.acl.AclOperation;

public class ClusterDescriptionConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ClusterDescription obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "authorizedOperations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<AclOperation> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(AclOperation.valueOf((String)((String)item)));
                        }
                    });
                    obj.setAuthorizedOperations(list);
                    break;
                }
                case "clusterId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClusterId((String)member.getValue());
                    break;
                }
                case "controller": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setController(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "nodes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<AclOperation> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((AclOperation)new Node((JsonObject)item));
                        }
                    });
                    obj.setNodes((List<Node>)((Object)list));
                }
            }
        }
    }

    static void toJson(ClusterDescription obj, JsonObject json) {
        ClusterDescriptionConverter.toJson(obj, json.getMap());
    }

    static void toJson(ClusterDescription obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getAuthorizedOperations() != null) {
            array = new JsonArray();
            obj.getAuthorizedOperations().forEach(item -> array.add((Object)item.name()));
            json.put("authorizedOperations", array);
        }
        if (obj.getClusterId() != null) {
            json.put("clusterId", obj.getClusterId());
        }
        if (obj.getController() != null) {
            json.put("controller", obj.getController().toJson());
        }
        if (obj.getNodes() != null) {
            array = new JsonArray();
            obj.getNodes().forEach(item -> array.add((Object)item.toJson()));
            json.put("nodes", array);
        }
    }
}

