/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.mail.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class Capabilities {
    private static final Logger log = LoggerFactory.getLogger(Capabilities.class);
    private Set<String> capaAuth = Collections.emptySet();
    private int capaSize;
    private boolean capaStartTLS;
    private boolean capaPipelining;

    Set<String> getCapaAuth() {
        return this.capaAuth;
    }

    int getSize() {
        return this.capaSize;
    }

    boolean isCapaPipelining() {
        return this.capaPipelining;
    }

    boolean isStartTLS() {
        return this.capaStartTLS;
    }

    Capabilities() {
    }

    void parseCapabilities(String message) {
        List<String> capabilities = this.parseEhlo(message);
        for (String c : capabilities) {
            if (c.equals("STARTTLS")) {
                this.capaStartTLS = true;
            }
            if (c.equals("PIPELINING")) {
                this.capaPipelining = true;
            }
            if (c.startsWith("AUTH ")) {
                this.capaAuth = Utils.parseCapaAuth(c.substring(5));
            }
            if (!c.startsWith("SIZE ")) continue;
            try {
                this.capaSize = Integer.parseInt(c.substring(5));
            }
            catch (NumberFormatException n) {
                this.capaSize = 0;
            }
        }
    }

    private List<String> parseEhlo(String message) {
        ArrayList<String> result = new ArrayList<String>();
        String resultCode = message.substring(0, 3);
        for (String line : Utils.splitByChar(message, '\n')) {
            if (!line.startsWith(resultCode) || line.charAt(3) != '-' && line.charAt(3) != ' ') {
                log.error((Object)"format error in multiline response");
                this.handleError("format error in multiline response");
                continue;
            }
            result.add(line.substring(4));
        }
        return result;
    }

    private void handleError(String msg) {
        log.error((Object)msg);
    }
}

