/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.tracing.opentelemetry.OpenTelemetryOptions;
import io.vertx.tracing.opentelemetry.OpenTelemetryTracer;

public class OpenTelemetryTracingFactory
implements VertxTracerFactory {
    static final OpenTelemetryTracingFactory INSTANCE = new OpenTelemetryTracingFactory();
    private final OpenTelemetry openTelemetry;

    public OpenTelemetryTracingFactory() {
        this(null);
    }

    public OpenTelemetryTracingFactory(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public VertxTracer<?, ?> tracer(TracingOptions options) {
        if (this.openTelemetry != null) {
            return new OpenTelemetryTracer(this.openTelemetry);
        }
        OpenTelemetryOptions openTelemetryOptions = options instanceof OpenTelemetryOptions ? (OpenTelemetryOptions)options : new OpenTelemetryOptions(options.toJson());
        return openTelemetryOptions.buildTracer();
    }

    public TracingOptions newOptions() {
        return new OpenTelemetryOptions();
    }

    public TracingOptions newOptions(JsonObject jsonObject) {
        return new OpenTelemetryOptions(jsonObject);
    }
}

