/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.serviceproxy.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HelperUtils {
    public static <T> Handler<AsyncResult<T>> createHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else if (res.result() != null && res.result().getClass().isEnum()) {
                msg.reply((Object)((Enum)res.result()).name());
            } else {
                msg.reply(res.result());
            }
        };
    }

    public static <T> Handler<AsyncResult<List<T>>> createListHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                msg.reply((Object)new JsonArray((List)res.result()));
            }
        };
    }

    public static <T> Handler<AsyncResult<Set<T>>> createSetHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                msg.reply((Object)new JsonArray(new ArrayList((Collection)res.result())));
            }
        };
    }

    public static Handler<AsyncResult<List<Character>>> createListCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (List)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    public static Handler<AsyncResult<Set<Character>>> createSetCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (Set)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    public static <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    public static <T> List<T> convertList(List list) {
        return list;
    }

    public static <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }
}

