/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2.internal;

import brave.context.rxjava2.internal.Util;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;

final class TraceContextObserver<T>
implements Observer<T>,
Disposable {
    final Observer<T> downstream;
    final CurrentTraceContext contextScoper;
    final TraceContext assembled;
    Disposable upstream;
    boolean done;

    TraceContextObserver(Observer<T> downstream, CurrentTraceContext contextScoper, TraceContext assembled) {
        this.downstream = downstream;
        this.contextScoper = contextScoper;
        this.assembled = assembled;
    }

    public final void onSubscribe(Disposable d) {
        if (!Util.validate(this.upstream, d)) {
            return;
        }
        this.upstream = d;
        this.downstream.onSubscribe((Disposable)this);
    }

    public void onNext(T t) {
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onNext(t);
        }
        finally {
            scope.close();
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onError(t);
        }
        finally {
            scope.close();
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onComplete();
        }
        finally {
            scope.close();
        }
    }

    public void dispose() {
        this.upstream.dispose();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }
}

