/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.ErrorParser;
import brave.SpanCustomizer;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;

public class GrpcParser {
    static final ErrorParser DEFAULT_ERROR_PARSER = new ErrorParser();

    protected ErrorParser errorParser() {
        return DEFAULT_ERROR_PARSER;
    }

    protected <ReqT, RespT> String spanName(MethodDescriptor<ReqT, RespT> methodDescriptor) {
        return methodDescriptor.getFullMethodName();
    }

    protected <M> void onMessageSent(M message, SpanCustomizer span) {
    }

    protected <M> void onMessageReceived(M message, SpanCustomizer span) {
    }

    protected void onClose(Status status, Metadata trailers, SpanCustomizer span) {
        if (status != null && status.getCode() != Status.Code.OK) {
            String code = String.valueOf(status.getCode());
            span.tag("grpc.status_code", code);
            span.tag("error", code);
        }
    }
}

