/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.grpc.TagContextBinaryMarshaller;
import brave.grpc.TraceContextBinaryMarshaller;
import brave.internal.MapPropagationFields;
import brave.internal.Nullable;
import brave.internal.PropagationFieldsFactory;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.grpc.Metadata;
import java.util.List;
import java.util.Map;

final class GrpcPropagation<K>
implements Propagation<K> {
    static final Metadata.Key<TraceContext> GRPC_TRACE_BIN = Metadata.Key.of((String)"grpc-trace-bin", (Metadata.BinaryMarshaller)new TraceContextBinaryMarshaller());
    static final Metadata.Key<Map<String, String>> GRPC_TAGS_BIN = Metadata.Key.of((String)"grpc-tags-bin", (Metadata.BinaryMarshaller)new TagContextBinaryMarshaller());
    static final String RPC_METHOD = "method";
    final Propagation<K> delegate;
    final TagsFactory extraFactory;

    static Propagation.Factory newFactory(Propagation.Factory delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        return new Factory(delegate);
    }

    GrpcPropagation(Factory factory, Propagation.KeyFactory<K> keyFactory) {
        this.delegate = factory.delegate.create(keyFactory);
        this.extraFactory = factory.tagsFactory;
    }

    public List<K> keys() {
        return this.delegate.keys();
    }

    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        return new GrpcInjector<C, K>(this, setter);
    }

    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        return new GrpcExtractor<C, K>(this, getter);
    }

    @Nullable
    static Tags findTags(TraceContext traceContext) {
        List extra = traceContext.extra();
        int length = extra.size();
        for (int i = 0; i < length; ++i) {
            Object next = extra.get(i);
            if (!(next instanceof Tags)) continue;
            return (Tags)((Object)next);
        }
        return null;
    }

    static final class Tags
    extends MapPropagationFields {
        final String parentMethod;

        Tags() {
            this.parentMethod = null;
        }

        Tags(Tags parent) {
            super((MapPropagationFields)parent);
            this.parentMethod = null;
        }

        Tags(Map<String, String> extracted, String parentMethod) {
            super(extracted);
            this.parentMethod = parentMethod;
        }
    }

    static final class TagsFactory
    extends PropagationFieldsFactory<Tags> {
        TagsFactory() {
        }

        protected Class type() {
            return Tags.class;
        }

        protected Tags create() {
            return new Tags();
        }

        protected Tags create(Tags parent) {
            return new Tags(parent);
        }
    }

    static final class GrpcExtractor<C, K>
    implements TraceContext.Extractor<C> {
        final GrpcPropagation<K> propagation;
        final TraceContext.Extractor<C> delegate;
        final Propagation.Getter<C, K> getter;

        GrpcExtractor(GrpcPropagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.propagation = propagation;
            this.delegate = propagation.delegate.extractor(getter);
            this.getter = getter;
        }

        public TraceContextOrSamplingFlags extract(C carrier) {
            Tags tags = null;
            if (carrier instanceof Metadata) {
                TraceContext extractedTrace = (TraceContext)((Metadata)carrier).get(GRPC_TRACE_BIN);
                Map extractedTags = (Map)((Metadata)carrier).get(GRPC_TAGS_BIN);
                if (extractedTags != null) {
                    tags = new Tags(extractedTags, (String)extractedTags.remove(GrpcPropagation.RPC_METHOD));
                }
                if (extractedTrace != null) {
                    if (tags == null) {
                        return TraceContextOrSamplingFlags.create((TraceContext)extractedTrace);
                    }
                    return TraceContextOrSamplingFlags.newBuilder().addExtra(tags).context(extractedTrace).build();
                }
            }
            TraceContextOrSamplingFlags result = this.delegate.extract(carrier);
            if (tags == null) {
                return result;
            }
            return result.toBuilder().addExtra(tags).build();
        }
    }

    static final class GrpcInjector<C, K>
    implements TraceContext.Injector<C> {
        final TraceContext.Injector<C> delegate;
        final Propagation.Setter<C, K> setter;

        GrpcInjector(GrpcPropagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.delegate = propagation.delegate.injector(setter);
            this.setter = setter;
        }

        public void inject(TraceContext traceContext, C carrier) {
            if (carrier instanceof Metadata) {
                ((Metadata)carrier).put(GRPC_TRACE_BIN, (Object)traceContext);
                Tags tags = GrpcPropagation.findTags(traceContext);
                if (tags != null) {
                    ((Metadata)carrier).put(GRPC_TAGS_BIN, (Object)tags.toMap());
                }
            }
            this.delegate.inject(traceContext, carrier);
        }
    }

    static final class Factory
    extends Propagation.Factory {
        final Propagation.Factory delegate;
        final TagsFactory tagsFactory = new TagsFactory();

        Factory(Propagation.Factory delegate) {
            this.delegate = delegate;
        }

        public boolean supportsJoin() {
            return false;
        }

        public boolean requires128BitTraceId() {
            return true;
        }

        public final <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            return new GrpcPropagation<K>(this, keyFactory);
        }

        public TraceContext decorate(TraceContext context) {
            TraceContext result = this.delegate.decorate(context);
            return this.tagsFactory.decorate(result);
        }
    }
}

