/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.NoopSpanCustomizer;
import brave.Span;
import brave.SpanCustomizer;
import brave.grpc.GrpcClientRequest;
import brave.grpc.GrpcClientResponse;
import brave.grpc.GrpcTracing;
import brave.grpc.MessageProcessor;
import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.rpc.RpcClientHandler;
import brave.rpc.RpcClientRequest;
import brave.rpc.RpcClientResponse;
import brave.rpc.RpcTracing;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class TracingClientInterceptor
implements ClientInterceptor {
    final Map<String, Metadata.Key<String>> nameToKey;
    final CurrentTraceContext currentTraceContext;
    final RpcClientHandler handler;
    final MessageProcessor messageProcessor;

    TracingClientInterceptor(GrpcTracing grpcTracing) {
        this.nameToKey = grpcTracing.nameToKey;
        this.currentTraceContext = grpcTracing.rpcTracing.tracing().currentTraceContext();
        this.handler = RpcClientHandler.create((RpcTracing)grpcTracing.rpcTracing);
        this.messageProcessor = grpcTracing.clientMessageProcessor;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new TracingClientCall<ReqT, RespT>(method, callOptions, this.currentTraceContext.get(), next.newCall(method, callOptions));
    }

    CurrentTraceContext.Scope maybeScopeClientOrInvocationContext(AtomicReference<Span> spanRef, @Nullable TraceContext invocationContext) {
        Span span = spanRef.get();
        TraceContext context = span != null ? span.context() : invocationContext;
        return this.currentTraceContext.maybeScope(context);
    }

    final class TracingClientCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        @Nullable
        final TraceContext invocationContext;
        final AtomicReference<Span> spanRef;
        final GrpcClientRequest request;
        final Metadata headers;

        TracingClientCallListener(@Nullable ClientCall.Listener<RespT> delegate, TraceContext invocationContext, AtomicReference<Span> spanRef, GrpcClientRequest request) {
            super(delegate);
            this.headers = new Metadata();
            this.invocationContext = invocationContext;
            this.spanRef = spanRef;
            this.request = request;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onReady() {
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);
            try {
                this.delegate().onReady();
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onHeaders(Metadata headers) {
            this.headers.merge(headers);
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate().onHeaders(headers);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onMessage(RespT message) {
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingClientInterceptor.this.messageProcessor.onMessageReceived(message, (SpanCustomizer)customizer);
                this.delegate().onMessage(message);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onClose(Status status, Metadata trailers) {
            GrpcClientResponse response = new GrpcClientResponse(this.request, this.headers, status, trailers);
            Span span = this.spanRef.getAndSet(null);
            if (span != null) {
                TracingClientInterceptor.this.handler.handleReceive((RpcClientResponse)response, span);
            }
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate().onClose(status, trailers);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }
    }

    final class TracingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        final MethodDescriptor<ReqT, RespT> method;
        final CallOptions callOptions;
        final TraceContext invocationContext;
        final AtomicReference<Span> spanRef;

        TracingClientCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, TraceContext invocationContext, ClientCall<ReqT, RespT> call) {
            super(call);
            this.spanRef = new AtomicReference();
            this.method = method;
            this.callOptions = callOptions;
            this.invocationContext = invocationContext;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void start(ClientCall.Listener<RespT> responseListener2, Metadata headers) {
            GrpcClientRequest request = new GrpcClientRequest(TracingClientInterceptor.this.nameToKey, this.method, this.callOptions, this.delegate(), (Metadata)headers);
            Span span = TracingClientInterceptor.this.handler.handleSendWithParent((RpcClientRequest)request, this.invocationContext);
            this.spanRef.set(span);
            TracingClientCallListener<RespT> responseListener2 = new TracingClientCallListener<RespT>(responseListener2, this.invocationContext, this.spanRef, request);
            try {
                CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(span.context());
                try {
                    super.start(responseListener2, (Metadata)headers);
                    if (scope == null) return;
                }
                catch (Throwable throwable) {
                    if (scope == null) throw throwable;
                    try {
                        scope.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                scope.close();
                return;
            }
            catch (Throwable e) {
                Throwables.propagateIfFatal((Throwable)e);
                this.spanRef.set(null);
                if (span == null) throw e;
                span.error(e).finish();
                throw e;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void cancel(@Nullable String message, @Nullable Throwable cause) {
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);
            try {
                this.delegate().cancel(message, cause);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void halfClose() {
            try {
                CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);
                try {
                    this.delegate().halfClose();
                    if (scope == null) return;
                }
                catch (Throwable throwable) {
                    if (scope == null) throw throwable;
                    try {
                        scope.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                scope.close();
                return;
            }
            catch (Throwable e) {
                Throwables.propagateIfFatal((Throwable)e);
                Span span = this.spanRef.getAndSet(null);
                if (span == null) throw e;
                span.error(e).finish();
                throw e;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void request(int numMessages) {
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);
            try {
                this.delegate().request(numMessages);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void sendMessage(ReqT message) {
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);
            try {
                this.delegate().sendMessage(message);
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingClientInterceptor.this.messageProcessor.onMessageSent(message, (SpanCustomizer)customizer);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }
    }
}

