/*
 * Decompiled with CFR 0.152.
 */
package brave.test.jakarta.http;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.test.ITRemote;
import brave.test.http.ITHttpServer;
import brave.test.http.ITServletContainer;
import brave.test.http.ServletContainer;
import brave.test.jakarta.http.Jetty11ServerController;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public abstract class ITServlet5Container
extends ITServletContainer {
    static ExecutorService executor = Executors.newCachedThreadPool();
    Filter delegate;
    Filter userFilter = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ((HttpServletResponse)response).setHeader("user_id", ITRemote.BAGGAGE_FIELD.getValue());
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter traceContextFilter = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            TraceContext context = (TraceContext)request.getAttribute("brave.propagation.TraceContext");
            String value = ITRemote.BAGGAGE_FIELD.getValue(context);
            ((HttpServletResponse)response).setHeader("user_id", value);
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter customHttpRoute = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            request.setAttribute("http.route", (Object)((HttpServletRequest)request).getRequestURI());
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter customHook = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ((SpanCustomizer)request.getAttribute("brave.SpanCustomizer")).tag("foo", "bar");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };

    public ITServlet5Container() {
        super((ServletContainer.ServerController)new Jetty11ServerController(), Log.getLogger((String)"org.eclipse.jetty.util.log"));
    }

    @AfterAll
    public static void shutdownExecutor() {
        executor.shutdownNow();
    }

    @Test
    protected void forward() throws Exception {
        this.get("/forward");
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void forwardAsync() throws Exception {
        this.get("/forwardAsync");
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void errorTag_onException_asyncTimeout() throws Exception {
        Response response = this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exceptionAsyncTimeout", "Timed out after 1ms");
        Assertions.assertThat((int)response.code()).isIn(new Object[]{500, 504});
    }

    @Test
    protected void currentSpanVisibleToOtherFilters() throws Exception {
        this.delegate = this.userFilter;
        String path = "/foo";
        Request request = new Request.Builder().url(this.url(path)).header("user_id", "abcdefg").build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            Assertions.assertThat((String)response.header("user_id")).isEqualTo("abcdefg");
        }
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void traceContextVisibleToOtherFilters() throws Exception {
        this.delegate = this.traceContextFilter;
        String path = "/foo";
        Request request = new Request.Builder().url(this.url(path)).header("user_id", "abcdefg").build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            Assertions.assertThat((String)response.header("user_id")).isEqualTo("abcdefg");
        }
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void canSetCustomRoute() throws Exception {
        this.delegate = this.customHttpRoute;
        this.get("/foo");
        Assertions.assertThat((String)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).name()).isEqualTo("GET /foo");
    }

    @Test
    protected void canUseSpanAttribute() throws Exception {
        this.delegate = this.customHook;
        this.get("/foo");
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).tags()).containsEntry((Object)"foo", (Object)"bar");
    }

    @Test
    protected void errorTag_onException_asyncDispatch() throws Exception {
        this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exceptionAsyncDispatch", "not ready");
    }

    public void init(ServletContextHandler handler) {
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(404)), "/*");
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(200)), "/foo");
        handler.addServlet(new ServletHolder((Servlet)new BaggageServlet()), "/baggage");
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(400)), "/badrequest");
        handler.addServlet(new ServletHolder((Servlet)new ChildServlet(this.httpTracing)), "/child");
        handler.addServlet(new ServletHolder((Servlet)new ExceptionServlet()), "/exception");
        this.addFilter(handler, this.newTracingFilter());
        this.addFilter(handler, new DelegatingFilter());
        handler.addServlet(new ServletHolder((Servlet)new AsyncServlet()), "/async");
        handler.addServlet(new ServletHolder((Servlet)new ForwardServlet()), "/forward");
        handler.addServlet(new ServletHolder((Servlet)new AsyncForwardServlet()), "/forwardAsync");
        handler.addServlet(new ServletHolder((Servlet)new ExceptionAsyncServlet()), "/exceptionAsync");
        handler.addServlet(new ServletHolder((Servlet)new TimeoutExceptionAsyncServlet()), "/exceptionAsyncTimeout");
        handler.addServlet(new ServletHolder((Servlet)new DispatchExceptionAsyncServlet()), "/exceptionAsyncDispatch");
    }

    protected abstract Filter newTracingFilter();

    protected abstract void addFilter(ServletContextHandler var1, Filter var2);

    static class DispatchExceptionAsyncServlet
    extends HttpServlet {
        DispatchExceptionAsyncServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            if (DispatcherType.ERROR.equals((Object)req.getDispatcherType())) {
                return;
            }
            if (req.getAttribute("dispatched") != null) {
                throw ITHttpServer.NOT_READY_ISE;
            }
            req.setAttribute("dispatched", (Object)Boolean.TRUE);
            req.startAsync().dispatch();
        }
    }

    static class TimeoutExceptionAsyncServlet
    extends HttpServlet {
        TimeoutExceptionAsyncServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            if (DispatcherType.ERROR.equals((Object)req.getDispatcherType())) {
                return;
            }
            AsyncContext ctx = req.startAsync();
            ctx.setTimeout(1L);
            ctx.start(() -> {
                resp.setStatus(504);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    ctx.complete();
                }
            });
        }
    }

    static class ExceptionAsyncServlet
    extends HttpServlet {
        ExceptionAsyncServlet() {
        }

        protected void doGet(final HttpServletRequest req, HttpServletResponse resp) {
            if (DispatcherType.ERROR.equals((Object)req.getDispatcherType())) {
                return;
            }
            AsyncContext async = req.startAsync();
            async.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) {
                }

                public void onTimeout(AsyncEvent event) {
                }

                public void onError(AsyncEvent event) {
                    req.setAttribute("jakarta.servlet.error.status_code", (Object)503);
                }

                public void onStartAsync(AsyncEvent event) {
                }
            });
            throw ITHttpServer.NOT_READY_ISE;
        }
    }

    static class AsyncServlet
    extends HttpServlet {
        AsyncServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            if (Tracing.currentTracer().currentSpan() == null) {
                throw new IllegalStateException("couldn't read current span!");
            }
            AsyncContext ctx = req.startAsync();
            ctx.start(() -> ((AsyncContext)ctx).complete());
        }
    }

    static class AsyncForwardServlet
    extends HttpServlet {
        AsyncForwardServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            AsyncContext asyncContext = req.startAsync((ServletRequest)req, (ServletResponse)resp);
            executor.execute(() -> asyncContext.dispatch("/async"));
        }
    }

    static class ForwardServlet
    extends HttpServlet {
        ForwardServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            req.getServletContext().getRequestDispatcher("/foo").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    static class ExceptionServlet
    extends HttpServlet {
        ExceptionServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            req.setAttribute("jakarta.servlet.error.status_code", (Object)503);
            throw ITHttpServer.NOT_READY_ISE;
        }
    }

    static class ChildServlet
    extends HttpServlet {
        final Tracer tracer;

        ChildServlet(HttpTracing httpTracing) {
            this.tracer = httpTracing.tracing().tracer();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            this.tracer.nextSpan().name("child").start().finish();
            resp.setStatus(200);
        }
    }

    static class BaggageServlet
    extends HttpServlet {
        BaggageServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().print(ITRemote.BAGGAGE_FIELD.getValue());
        }
    }

    static class StatusServlet
    extends HttpServlet {
        final int status;

        StatusServlet(int status) {
            this.status = status;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            resp.setStatus(this.status);
        }
    }

    class DelegatingFilter
    implements Filter {
        DelegatingFilter() {
        }

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (ITServlet5Container.this.delegate == null) {
                chain.doFilter(request, response);
            } else {
                ITServlet5Container.this.delegate.doFilter(request, response, chain);
            }
        }

        public void destroy() {
        }
    }
}

