/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;

public abstract class ServletContainer {
    final ServerController serverController;
    int port = 0;
    Server server;

    protected ServletContainer(ServerController serverController) {
        this.serverController = serverController;
    }

    public final void init() {
        this.stop();
        this.server = this.serverController.newServer(this.port);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        this.init(context);
        try {
            this.server.start();
            this.port = this.serverController.getLocalPort(this.server);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start server.", e);
        }
    }

    public final String url(String path) {
        return "http://localhost:" + this.port + path;
    }

    public abstract void init(ServletContextHandler var1);

    public void stop() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
            this.server.join();
            this.server = null;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static interface ServerController {
        public Server newServer(int var1);

        public int getLocalPort(Server var1);
    }
}

