/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.Clock;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.http.HttpAdapter;
import brave.http.HttpClientParser;
import brave.http.HttpRequestMatchers;
import brave.http.HttpResponseParser;
import brave.http.HttpRuleSampler;
import brave.http.HttpTags;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.Sampler;
import brave.sampler.SamplerFunction;
import brave.test.ITRemote;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class ITHttpClient<C>
extends ITRemote {
    @Rule
    public MockWebServer server = new MockWebServer();
    protected C client;
    protected HttpTracing httpTracing = HttpTracing.create((Tracing)this.tracing);
    protected TraceContext.Extractor<RecordedRequest> extractor = this.propagationFactory.get().extractor(RecordedRequest::getHeader);

    @Before
    public void setup() throws IOException {
        this.client = this.newClient(this.server.getPort());
    }

    protected abstract C newClient(int var1) throws IOException;

    protected abstract void closeClient(C var1) throws IOException;

    protected abstract void options(C var1, String var2) throws IOException;

    protected abstract void get(C var1, String var2) throws IOException;

    protected abstract void post(C var1, String var2, String var3) throws IOException;

    @After
    public void close() throws Exception {
        this.closeClient(this.client);
        super.close();
    }

    @Test
    public void propagatesNewTrace() throws Exception {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        TraceContext extracted = this.extract(this.takeRequest());
        Assertions.assertThat((Boolean)extracted.sampled()).isTrue();
        Assertions.assertThat((String)extracted.parentIdString()).isNull();
        this.assertSameIds(this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT), extracted);
    }

    @Test
    public void propagatesChildOfCurrentSpan() throws IOException {
        this.server.enqueue(new MockResponse());
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(parent);){
            this.get(this.client, "/foo");
        }
        TraceContext extracted = this.extract(this.takeRequest());
        Assertions.assertThat((Boolean)extracted.sampled()).isTrue();
        this.assertChildOf(extracted, parent);
        this.assertSameIds(this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT), extracted);
    }

    @Test
    public void propagatesUnsampledContext() throws IOException {
        this.server.enqueue(new MockResponse());
        TraceContext parent = this.newTraceContext(SamplingFlags.NOT_SAMPLED);
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(parent);){
            this.get(this.client, "/foo");
        }
        TraceContext extracted = this.extract(this.takeRequest());
        Assertions.assertThat((Boolean)extracted.sampled()).isFalse();
        this.assertChildOf(extracted, parent);
    }

    @Test
    public void propagatesBaggage() throws IOException {
        this.server.enqueue(new MockResponse());
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(parent);){
            BAGGAGE_FIELD.updateValue(parent, "joey");
            this.get(this.client, "/foo");
        }
        TraceContext extracted = this.extract(this.takeRequest());
        Assertions.assertThat((String)BAGGAGE_FIELD.getValue(extracted)).isEqualTo("joey");
        this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT);
    }

    @Test
    public void propagatesBaggage_unsampled() throws IOException {
        this.server.enqueue(new MockResponse());
        TraceContext parent = this.newTraceContext(SamplingFlags.NOT_SAMPLED);
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(parent);){
            BAGGAGE_FIELD.updateValue(parent, "joey");
            this.get(this.client, "/foo");
        }
        TraceContext extracted = this.extract(this.takeRequest());
        Assertions.assertThat((String)BAGGAGE_FIELD.getValue(extracted)).isEqualTo("joey");
    }

    @Test
    public void customSampler() throws IOException {
        String path = "/foo";
        this.closeClient(this.client);
        HttpRuleSampler sampler = HttpRuleSampler.newBuilder().putRule(HttpRequestMatchers.pathStartsWith((String)path), Sampler.NEVER_SAMPLE).build();
        this.httpTracing = this.httpTracing.toBuilder().clientSampler((SamplerFunction)sampler).build();
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, path);
        Assertions.assertThat((Boolean)this.extract(this.takeRequest()).sampled()).isFalse();
    }

    @Test
    public void clientTimestampAndDurationEnclosedByParent() throws IOException {
        this.server.enqueue(new MockResponse());
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        Clock clock = this.tracing.clock(parent);
        long start = clock.currentTimeMicroseconds();
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(parent);){
            this.get(this.client, "/foo");
        }
        long finish = clock.currentTimeMicroseconds();
        MutableSpan clientSpan = this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT);
        this.assertChildOf(clientSpan, parent);
        this.assertSpanInInterval(clientSpan, start, finish);
    }

    @Test
    public void reportsClientKindToZipkin() throws IOException {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT);
    }

    @Test
    public void reportsServerAddress() throws IOException {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        Assertions.assertThat((Object)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT)).extracting(new Function[]{MutableSpan::remoteIp, MutableSpan::remotePort}).containsExactly(new Object[]{"127.0.0.1", this.server.getPort()});
    }

    @Test
    public void defaultSpanNameIsMethodName() throws IOException {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        Assertions.assertThat((String)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT).name()).isEqualTo("GET");
    }

    @Test
    public void readsRequestAtResponseTime() throws IOException {
        String uri = "/foo/bar?z=2&yAA=1";
        this.closeClient(this.client);
        this.httpTracing = this.httpTracing.toBuilder().clientResponseParser((response, context, span) -> HttpTags.URL.tag((Object)response.request(), span)).build();
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, uri);
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT).tags()).containsEntry((Object)"http.url", (Object)this.url(uri));
    }

    @Test
    public void supportsPortableCustomization() throws IOException {
        String uri = "/foo/bar?z=2&yAA=1";
        this.closeClient(this.client);
        this.httpTracing = this.httpTracing.toBuilder().clientRequestParser((request, context, span) -> {
            span.name(request.method().toLowerCase() + " " + request.path());
            HttpTags.URL.tag((Object)request, span);
            span.tag("request_customizer.is_span", (span instanceof Span) + "");
        }).clientResponseParser((response, context, span) -> {
            HttpResponseParser.DEFAULT.parse(response, context, span);
            span.tag("response_customizer.is_span", (span instanceof Span) + "");
        }).build().clientOf("remote-service");
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, uri);
        MutableSpan span2 = this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT);
        Assertions.assertThat((String)span2.name()).isEqualTo("get /foo/bar");
        Assertions.assertThat((String)span2.remoteServiceName()).isEqualTo("remote-service");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)span2.tags()).containsEntry((Object)"http.url", (Object)this.url(uri))).containsEntry((Object)"request_customizer.is_span", (Object)"false")).containsEntry((Object)"response_customizer.is_span", (Object)"false");
    }

    @Deprecated
    @Test
    public void supportsDeprecatedPortableCustomization() throws IOException {
        String uri = "/foo/bar?z=2&yAA=1";
        this.closeClient(this.client);
        this.httpTracing = this.httpTracing.toBuilder().clientParser(new HttpClientParser(){

            public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer) {
                customizer.name(adapter.method(req).toLowerCase() + " " + adapter.path(req));
                customizer.tag("http.url", adapter.url(req));
                customizer.tag("context.visible", String.valueOf(ITHttpClient.this.currentTraceContext.get() != null));
                customizer.tag("request_customizer.is_span", (customizer instanceof Span) + "");
            }

            public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer) {
                super.response(adapter, res, error, customizer);
                customizer.tag("response_customizer.is_span", (customizer instanceof Span) + "");
            }
        }).build().clientOf("remote-service");
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, uri);
        MutableSpan span = this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT);
        Assertions.assertThat((String)span.name()).isEqualTo("get /foo/bar");
        Assertions.assertThat((String)span.remoteServiceName()).isEqualTo("remote-service");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.url", (Object)this.url(uri))).containsEntry((Object)"context.visible", (Object)"true")).containsEntry((Object)"request_customizer.is_span", (Object)"false")).containsEntry((Object)"response_customizer.is_span", (Object)"false");
    }

    @Test
    public void addsStatusCodeWhenNotOk() throws IOException {
        this.server.enqueue(new MockResponse().setResponseCode(400));
        try {
            this.get(this.client, "/foo");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpanWithErrorTag(Span.Kind.CLIENT, "400").tags()).containsEntry((Object)"http.status_code", (Object)"400");
    }

    @Test
    public void redirect() throws IOException {
        this.server.enqueue(new MockResponse().setResponseCode(302).addHeader("Location: " + this.url("/bar")));
        this.server.enqueue(new MockResponse().setResponseCode(404));
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(parent);){
            this.get(this.client, "/foo");
        }
        catch (RuntimeException scope2) {
            // empty catch block
        }
        MutableSpan initial = this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT);
        MutableSpan redirected = this.testSpanHandler.takeRemoteSpanWithErrorTag(Span.Kind.CLIENT, "404");
        for (MutableSpan child : Arrays.asList(initial, redirected)) {
            this.assertChildOf(child, parent);
        }
        this.assertSequential(initial, redirected);
        Assertions.assertThat((String)((String)initial.tags().get("http.path"))).isEqualTo("/foo");
        Assertions.assertThat((String)((String)redirected.tags().get("http.path"))).isEqualTo("/bar");
    }

    @Test
    public void emptyPath() throws IOException {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "");
        Assertions.assertThat((String)this.takeRequest().getPath()).isEqualTo("/");
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT).tags()).containsEntry((Object)"http.path", (Object)"/");
    }

    @Test
    public void options() throws IOException {
        this.server.enqueue(new MockResponse().setResponseCode(204));
        this.options(this.client, "");
        Assertions.assertThat((String)this.takeRequest().getMethod()).isEqualTo("OPTIONS");
        ((MapAssert)Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT).tags()).containsEntry((Object)"http.method", (Object)"OPTIONS")).containsEntry((Object)"http.path", (Object)"/");
    }

    @Test
    public void post() throws IOException {
        String path = "/post";
        String body = "body";
        this.server.enqueue(new MockResponse());
        this.post(this.client, path, body);
        Assertions.assertThat((String)this.takeRequest().getBody().readUtf8()).isEqualTo(body);
        Assertions.assertThat((String)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT).name()).isEqualTo("POST");
    }

    @Test
    public void httpPathTagExcludesQueryParams() throws IOException {
        String path = "/foo?z=2&yAA=1";
        this.server.enqueue(new MockResponse());
        this.get(this.client, path);
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT).tags()).containsEntry((Object)"http.path", (Object)"/foo");
    }

    @Test
    public void spanHandlerSeesError() throws IOException {
        this.spanHandlerSeesError(this.get());
    }

    @Test
    public void setsError_onTransportException() {
        this.checkReportsSpanOnTransportException(this.get());
    }

    Callable<Void> get() {
        return () -> {
            this.get(this.client, "/foo");
            return null;
        };
    }

    void spanHandlerSeesError(Callable<Void> get) throws IOException {
        final ConcurrentLinkedDeque caughtThrowables = new ConcurrentLinkedDeque();
        this.closeClient(this.client);
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.ALWAYS_SAMPLE).clearSpanHandlers().addSpanHandler(new SpanHandler(){

            public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
                Throwable error = span.error();
                if (error != null) {
                    caughtThrowables.add(error);
                } else {
                    caughtThrowables.add(new RuntimeException("Unexpected additional call to end"));
                }
                return true;
            }
        }).addSpanHandler((SpanHandler)this.testSpanHandler).build());
        this.client = this.newClient(this.server.getPort());
        this.checkReportsSpanOnTransportException(get);
        ((IterableAssert)Assertions.assertThat(caughtThrowables).withFailMessage("Span finished with error, but caughtThrowables empty", new Object[0])).isNotEmpty();
        if (caughtThrowables.size() > 1) {
            for (Throwable throwable : caughtThrowables) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "multiple calls to finish", throwable);
            }
            Assertions.assertThat(caughtThrowables).hasSize(1);
        }
    }

    MutableSpan checkReportsSpanOnTransportException(Callable<Void> get) {
        this.server.enqueue(new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_START));
        try {
            get.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.testSpanHandler.takeRemoteSpanWithError(Span.Kind.CLIENT);
    }

    protected String url(String pathIncludingQuery) {
        return "http://127.0.0.1:" + this.server.getPort() + pathIncludingQuery;
    }

    protected RecordedRequest takeRequest() {
        try {
            return this.server.takeRequest(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }

    protected TraceContext extract(RecordedRequest request) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)request);
        ((ObjectAssert)Assertions.assertThat((Object)extracted.context()).withFailMessage("Expected to extract a trace context from %s", new Object[]{request.getHeaders()})).isNotNull();
        return extracted.context();
    }
}

