/*
 * Decompiled with CFR 0.152.
 */
package brave.httpasyncclient;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public final class TracingHttpAsyncClientBuilder
extends HttpAsyncClientBuilder {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    public static HttpAsyncClientBuilder create(Tracing tracing) {
        return new TracingHttpAsyncClientBuilder(HttpTracing.create((Tracing)tracing));
    }

    public static HttpAsyncClientBuilder create(HttpTracing httpTracing) {
        return new TracingHttpAsyncClientBuilder(httpTracing);
    }

    TracingHttpAsyncClientBuilder(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public CloseableHttpAsyncClient build() {
        super.addInterceptorFirst((HttpRequestInterceptor)new HandleSend());
        super.addInterceptorLast((HttpRequestInterceptor)new RemoveScope());
        super.addInterceptorLast((HttpResponseInterceptor)new HandleReceive());
        return new TracingHttpAsyncClient(super.build());
    }

    static void removeScope(HttpContext context) {
        CurrentTraceContext.Scope scope = (CurrentTraceContext.Scope)context.removeAttribute(CurrentTraceContext.Scope.class.getName());
        if (scope == null) {
            return;
        }
        context.removeAttribute(CurrentTraceContext.Scope.class.getName());
        scope.close();
    }

    static void parseTargetAddress(HttpHost target, Span span) {
        if (span.isNoop()) {
            return;
        }
        if (target == null) {
            return;
        }
        InetAddress address = target.getAddress();
        if (address != null && span.remoteIpAndPort(address.getHostAddress(), target.getPort())) {
            return;
        }
        span.remoteIpAndPort(target.getHostName(), target.getPort());
    }

    final class HandleSend
    implements HttpRequestInterceptor {
        HandleSend() {
        }

        public void process(HttpRequest request, HttpContext context) {
            TraceContext parent = (TraceContext)context.getAttribute(TraceContext.class.getName());
            HttpRequestWrapper wrapper = new HttpRequestWrapper(request, context);
            Span span = TracingHttpAsyncClientBuilder.this.handler.handleSendWithParent((HttpClientRequest)wrapper, parent);
            TracingHttpAsyncClientBuilder.parseTargetAddress(wrapper.target, span);
            context.setAttribute(Span.class.getName(), (Object)span);
            context.setAttribute(CurrentTraceContext.Scope.class.getName(), (Object)TracingHttpAsyncClientBuilder.this.currentTraceContext.newScope(span.context()));
        }
    }

    static final class RemoveScope
    implements HttpRequestInterceptor {
        RemoveScope() {
        }

        public void process(HttpRequest request, HttpContext context) {
            TracingHttpAsyncClientBuilder.removeScope(context);
        }
    }

    final class HandleReceive
    implements HttpResponseInterceptor {
        HandleReceive() {
        }

        public void process(HttpResponse response, HttpContext context) {
            Span span = (Span)context.removeAttribute(Span.class.getName());
            if (span == null) {
                return;
            }
            TracingHttpAsyncClientBuilder.this.handler.handleReceive((HttpClientResponse)new HttpResponseWrapper(response, context, null), span);
        }
    }

    final class TracingHttpAsyncClient
    extends CloseableHttpAsyncClient {
        private final CloseableHttpAsyncClient delegate;

        TracingHttpAsyncClient(CloseableHttpAsyncClient delegate) {
            this.delegate = delegate;
        }

        public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext httpContext, FutureCallback<T> callback) {
            TraceContext invocationContext = TracingHttpAsyncClientBuilder.this.currentTraceContext.get();
            if (invocationContext != null) {
                httpContext.setAttribute(TraceContext.class.getName(), (Object)invocationContext);
            }
            return this.delegate.execute((HttpAsyncRequestProducer)new TracingAsyncRequestProducer(requestProducer, httpContext), new TracingAsyncResponseConsumer<T>(responseConsumer, httpContext), httpContext, callback != null && invocationContext != null ? new TraceContextFutureCallback(callback, TracingHttpAsyncClientBuilder.this.currentTraceContext, invocationContext) : callback);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean isRunning() {
            return this.delegate.isRunning();
        }

        public void start() {
            this.delegate.start();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static final class HttpResponseWrapper
    extends HttpClientResponse {
        @Nullable
        final HttpRequestWrapper request;
        @Nullable
        final HttpResponse response;
        @Nullable
        final Throwable error;

        HttpResponseWrapper(@Nullable HttpResponse response, HttpContext context, @Nullable Throwable error) {
            if (context == null) {
                throw new NullPointerException("context == null");
            }
            HttpRequest request = HttpClientContext.adapt((HttpContext)context).getRequest();
            this.request = request != null ? new HttpRequestWrapper(request, context) : null;
            this.response = response;
            this.error = error;
        }

        public Object unwrap() {
            return this.response;
        }

        @Nullable
        public HttpRequestWrapper request() {
            return this.request;
        }

        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            if (this.response == null) {
                return 0;
            }
            StatusLine statusLine = this.response.getStatusLine();
            return statusLine != null ? statusLine.getStatusCode() : 0;
        }
    }

    static final class HttpRequestWrapper
    extends HttpClientRequest {
        final HttpRequest request;
        @Nullable
        final HttpHost target;

        HttpRequestWrapper(HttpRequest request, HttpContext context) {
            this.request = request;
            this.target = HttpClientContext.adapt((HttpContext)context).getTargetHost();
        }

        public Object unwrap() {
            return this.request;
        }

        public String method() {
            return this.request.getRequestLine().getMethod();
        }

        public String path() {
            String result = this.request.getRequestLine().getUri();
            int queryIndex = result.indexOf(63);
            return queryIndex == -1 ? result : result.substring(0, queryIndex);
        }

        public String url() {
            if (this.target != null) {
                return this.target.toURI() + this.request.getRequestLine().getUri();
            }
            return this.request.getRequestLine().getUri();
        }

        public String header(String name) {
            Header result = this.request.getFirstHeader(name);
            return result != null ? result.getValue() : null;
        }

        public void header(String name, String value) {
            this.request.setHeader(name, value);
        }
    }

    final class TracingAsyncResponseConsumer<T>
    implements HttpAsyncResponseConsumer<T> {
        final HttpAsyncResponseConsumer<T> responseConsumer;
        final HttpContext context;

        TracingAsyncResponseConsumer(HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context) {
            this.responseConsumer = responseConsumer;
            this.context = context;
        }

        public void responseReceived(HttpResponse response) throws IOException, HttpException {
            this.responseConsumer.responseReceived(response);
        }

        public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            this.responseConsumer.consumeContent(decoder, ioctrl);
        }

        public void responseCompleted(HttpContext context) {
            this.responseConsumer.responseCompleted(context);
        }

        public void failed(Exception ex) {
            TracingHttpAsyncClientBuilder.removeScope(this.context);
            Span currentSpan = (Span)this.context.removeAttribute(Span.class.getName());
            if (currentSpan != null) {
                TracingHttpAsyncClientBuilder.this.handler.handleReceive((HttpClientResponse)new HttpResponseWrapper(null, this.context, ex), currentSpan);
            }
            this.responseConsumer.failed(ex);
        }

        public Exception getException() {
            return this.responseConsumer.getException();
        }

        public T getResult() {
            return (T)this.responseConsumer.getResult();
        }

        public boolean isDone() {
            return this.responseConsumer.isDone();
        }

        public void close() throws IOException {
            this.responseConsumer.close();
        }

        public boolean cancel() {
            return this.responseConsumer.cancel();
        }
    }

    final class TracingAsyncRequestProducer
    implements HttpAsyncRequestProducer {
        final HttpAsyncRequestProducer requestProducer;
        final HttpContext context;

        TracingAsyncRequestProducer(HttpAsyncRequestProducer requestProducer, HttpContext context) {
            this.requestProducer = requestProducer;
            this.context = context;
        }

        public void close() throws IOException {
            this.requestProducer.close();
        }

        public HttpHost getTarget() {
            return this.requestProducer.getTarget();
        }

        public HttpRequest generateRequest() throws IOException, HttpException {
            return this.requestProducer.generateRequest();
        }

        public void produceContent(ContentEncoder encoder, IOControl io) throws IOException {
            this.requestProducer.produceContent(encoder, io);
        }

        public void requestCompleted(HttpContext context) {
            this.requestProducer.requestCompleted(context);
        }

        public void failed(Exception ex) {
            TracingHttpAsyncClientBuilder.removeScope(this.context);
            Span currentSpan = (Span)this.context.removeAttribute(Span.class.getName());
            if (currentSpan != null) {
                TracingHttpAsyncClientBuilder.this.handler.handleReceive((HttpClientResponse)new HttpResponseWrapper(null, this.context, ex), currentSpan);
            }
            this.requestProducer.failed(ex);
        }

        public boolean isRepeatable() {
            return this.requestProducer.isRepeatable();
        }

        public void resetRequest() throws IOException {
            this.requestProducer.resetRequest();
        }
    }

    static final class TraceContextFutureCallback<T>
    implements FutureCallback<T> {
        final FutureCallback<T> delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextFutureCallback(FutureCallback<T> delegate, CurrentTraceContext currentTraceContext, TraceContext invocationContext) {
            this.delegate = delegate;
            this.currentTraceContext = currentTraceContext;
            this.invocationContext = invocationContext;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void completed(T t) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate.completed(t);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void failed(Exception e) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate.failed(e);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void cancelled() {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate.cancelled();
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

