/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient5;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.httpclient5.AsyncExecCallbackWrapper;
import brave.httpclient5.HttpClientUtils;
import brave.httpclient5.HttpRequestWrapper;
import brave.httpclient5.HttpResponseWrapper;
import brave.internal.Throwables;
import brave.propagation.TraceContext;
import java.io.IOException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;

class AsyncHandleSendHandler
implements AsyncExecChainHandler {
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    AsyncHandleSendHandler(HttpTracing httpTracing) {
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        HttpClientContext context = scope.clientContext;
        TraceContext parent = (TraceContext)context.getAttribute(TraceContext.class.getName());
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request, scope.route.getTargetHost());
        Span span = this.handler.handleSendWithParent((HttpClientRequest)requestWrapper, parent);
        context.setAttribute(Span.class.getName(), (Object)span);
        HttpClientUtils.parseTargetAddress(requestWrapper.target, span);
        AsyncExecCallbackWrapper callbackWrapper = new AsyncExecCallbackWrapper(asyncExecCallback, requestWrapper, this.handler, span, context);
        try {
            chain.proceed(request, entityProducer, scope, (AsyncExecCallback)callbackWrapper);
        }
        catch (Throwable e) {
            Throwables.propagateIfFatal((Throwable)e);
            context.removeAttribute(Span.class.getName());
            HttpClientUtils.closeScope((HttpContext)context);
            this.handler.handleReceive((HttpClientResponse)new HttpResponseWrapper(null, requestWrapper, e), span);
            throw e;
        }
    }
}

