/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.TracingConsumer;
import brave.jakarta.jms.TracingMessageListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

final class TracingJMSConsumer
extends TracingConsumer<JMSConsumer>
implements JMSConsumer {
    final Destination destination;

    TracingJMSConsumer(JMSConsumer delegate, Destination destination, JmsTracing jmsTracing) {
        super(delegate, jmsTracing);
        this.destination = destination;
    }

    @Override
    Destination destination(Message message) {
        return this.destination;
    }

    public String getMessageSelector() {
        return ((JMSConsumer)this.delegate).getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        return ((JMSConsumer)this.delegate).getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        ((JMSConsumer)this.delegate).setMessageListener(TracingMessageListener.create(listener, this.jmsTracing));
    }

    public Message receive() {
        Message message = ((JMSConsumer)this.delegate).receive();
        this.handleReceive(message);
        return message;
    }

    public Message receive(long timeout) {
        Message message = ((JMSConsumer)this.delegate).receive(timeout);
        this.handleReceive(message);
        return message;
    }

    public Message receiveNoWait() {
        Message message = ((JMSConsumer)this.delegate).receiveNoWait();
        this.handleReceive(message);
        return message;
    }

    public void close() {
        ((JMSConsumer)this.delegate).close();
    }

    public <T> T receiveBody(Class<T> c) {
        return (T)((JMSConsumer)this.delegate).receiveBody(c);
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        return (T)((JMSConsumer)this.delegate).receiveBody(c, timeout);
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        return (T)((JMSConsumer)this.delegate).receiveBodyNoWait(c);
    }
}

