/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.internal.Nullable;
import brave.jms.MessageParser;
import brave.jms.MessageProperties;
import brave.messaging.ConsumerRequest;
import brave.propagation.Propagation;
import javax.jms.Destination;
import javax.jms.Message;

final class MessageConsumerRequest
extends ConsumerRequest {
    static final Propagation.RemoteGetter<MessageConsumerRequest> GETTER = new Propagation.RemoteGetter<MessageConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public String get(MessageConsumerRequest request, String name) {
            return MessageProperties.getPropertyIfString(request.delegate, name);
        }

        public String toString() {
            return "Message::getStringProperty";
        }
    };
    static final Propagation.RemoteSetter<MessageConsumerRequest> SETTER = new Propagation.RemoteSetter<MessageConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public void put(MessageConsumerRequest request, String name, String value) {
            MessageProperties.setStringProperty(request.delegate, name, value);
        }

        public String toString() {
            return "Message::setStringProperty";
        }
    };
    final Message delegate;
    @Nullable
    final Destination destination;

    MessageConsumerRequest(Message delegate, @Nullable Destination destination) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
        this.destination = destination;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return MessageParser.channelKind(this.destination);
    }

    public String channelName() {
        return MessageParser.channelName(this.destination);
    }
}

