/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.internal.Nullable;
import brave.jms.MessageParser;
import brave.jms.MessageProperties;
import brave.messaging.ProducerRequest;
import brave.propagation.Propagation;
import javax.jms.Destination;
import javax.jms.Message;

final class MessageProducerRequest
extends ProducerRequest {
    static final Propagation.RemoteGetter<MessageProducerRequest> GETTER = new Propagation.RemoteGetter<MessageProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public String get(MessageProducerRequest request, String name) {
            return MessageProperties.getPropertyIfString(request.delegate, name);
        }

        public String toString() {
            return "Message::getStringProperty";
        }
    };
    static final Propagation.RemoteSetter<MessageProducerRequest> SETTER = new Propagation.RemoteSetter<MessageProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public void put(MessageProducerRequest request, String name, String value) {
            MessageProperties.setStringProperty(request.delegate, name, value);
        }

        public String toString() {
            return "Message::setStringProperty";
        }
    };
    final Message delegate;
    @Nullable
    final Destination destination;

    MessageProducerRequest(Message delegate, @Nullable Destination destination) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
        this.destination = destination;
    }

    public Span.Kind spanKind() {
        return Span.Kind.PRODUCER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "send";
    }

    public String channelKind() {
        return MessageParser.channelKind(this.destination);
    }

    public String channelName() {
        return MessageParser.channelName(this.destination);
    }
}

