/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.kafka.clients.KafkaPropagation;
import brave.kafka.clients.TracingConsumer;
import brave.kafka.clients.TracingProducer;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.header.Headers;

public final class KafkaTracing {
    private final Tracing tracing;
    private final TraceContext.Extractor<Headers> extractor;
    private final String remoteServiceName;

    public static KafkaTracing create(Tracing tracing) {
        return new Builder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    KafkaTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.extractor = this.tracing.propagation().extractor(KafkaPropagation.HEADER_GETTER);
        this.remoteServiceName = builder.remoteServiceName;
    }

    public <K, V> Consumer<K, V> consumer(Consumer<K, V> consumer) {
        return new TracingConsumer<K, V>(this.tracing, consumer, this.remoteServiceName);
    }

    public <K, V> Producer<K, V> producer(Producer<K, V> producer) {
        return new TracingProducer<K, V>(this.tracing, producer, this.remoteServiceName);
    }

    public Span nextSpan(ConsumerRecord<?, ?> record) {
        TraceContextOrSamplingFlags extracted = this.extractAndClearHeaders(record);
        Span result = this.tracing.tracer().nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            KafkaTracing.addTags(record, (SpanCustomizer)result);
        }
        return result;
    }

    TraceContextOrSamplingFlags extractAndClearHeaders(ConsumerRecord<?, ?> record) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)record.headers());
        if (extracted != TraceContextOrSamplingFlags.EMPTY) {
            this.tracing.propagation().keys().forEach(key -> record.headers().remove(key));
        }
        return extracted;
    }

    static void addTags(ConsumerRecord<?, ?> record, SpanCustomizer result) {
        if (record.key() instanceof String && !"".equals(record.key())) {
            result.tag("kafka.key", record.key().toString());
        }
        result.tag("kafka.topic", record.topic());
    }

    public static final class Builder {
        final Tracing tracing;
        String remoteServiceName = "kafka";

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public KafkaTracing build() {
            return new KafkaTracing(this);
        }
    }
}

