/*
 * Decompiled with CFR 0.152.
 */
package brave.mysql6;

import brave.Span;
import brave.propagation.ThreadLocalSpan;
import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptor;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.jdbc.PreparedStatement;
import java.net.URI;
import java.sql.SQLException;
import java.util.Properties;

@Deprecated
public class TracingStatementInterceptor
implements StatementInterceptor {
    private MysqlConnection connection;

    public <T extends Resultset> T preProcess(String sql, Statement interceptedStatement) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.next();
        if (span == null || span.isNoop()) {
            return null;
        }
        if (interceptedStatement instanceof PreparedStatement) {
            sql = ((PreparedStatement)interceptedStatement).getPreparedSql();
        }
        int spaceIndex = sql.indexOf(32);
        span.kind(Span.Kind.CLIENT).name(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        span.tag("sql.query", sql);
        TracingStatementInterceptor.parseServerIpAndPort(this.connection, span);
        span.start();
        return null;
    }

    public <T extends Resultset> T postProcess(String sql, Statement interceptedStatement, T originalResultSet, int warningCount, boolean noIndexUsed, boolean noGoodIndexUsed, Exception error) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return null;
        }
        span.error((Throwable)error);
        if (error instanceof SQLException) {
            span.tag("error", Integer.toString(((SQLException)error).getErrorCode()));
        }
        span.finish();
        return null;
    }

    static void parseServerIpAndPort(MysqlConnection connection, Span span) {
        try {
            URI url = URI.create(connection.getURL().substring(5));
            String remoteServiceName = connection.getProperties().getProperty("zipkinServiceName");
            if (remoteServiceName == null || "".equals(remoteServiceName)) {
                String databaseName = TracingStatementInterceptor.getDatabaseName(connection);
                remoteServiceName = databaseName != null && !databaseName.isEmpty() ? "mysql-" + databaseName : "mysql";
            }
            span.remoteServiceName(remoteServiceName);
            String host = TracingStatementInterceptor.getHost(connection);
            if (host != null) {
                span.remoteIpAndPort(host, url.getPort() == -1 ? 3306 : url.getPort());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getDatabaseName(MysqlConnection connection) throws SQLException {
        if (connection instanceof JdbcConnection) {
            return ((JdbcConnection)connection).getCatalog();
        }
        return "";
    }

    private static String getHost(MysqlConnection connection) {
        if (!(connection instanceof JdbcConnection)) {
            return null;
        }
        return ((JdbcConnection)connection).getHost();
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public StatementInterceptor init(MysqlConnection mysqlConnection, Properties properties, Log log) {
        TracingStatementInterceptor interceptor = new TracingStatementInterceptor();
        interceptor.connection = mysqlConnection;
        return interceptor;
    }

    public void destroy() {
    }
}

