/*
 * Decompiled with CFR 0.152.
 */
package brave.mysql8;

import brave.Span;
import brave.mysql8.TracingExceptionInterceptor;
import brave.propagation.ThreadLocalSpan;
import com.mysql.cj.MysqlConnection;
import com.mysql.cj.Query;
import com.mysql.cj.interceptors.QueryInterceptor;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.log.Log;
import com.mysql.cj.protocol.Resultset;
import com.mysql.cj.protocol.ServerSession;
import java.net.URI;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Supplier;

public class TracingQueryInterceptor
implements QueryInterceptor {
    private MysqlConnection connection;
    private boolean interceptingExceptions;

    public <T extends Resultset> T preProcess(Supplier<String> sqlSupplier, Query interceptedQuery) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.next();
        if (span == null || span.isNoop()) {
            return null;
        }
        String sql = sqlSupplier.get();
        int spaceIndex = sql.indexOf(32);
        span.kind(Span.Kind.CLIENT).name(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        span.tag("sql.query", sql);
        TracingQueryInterceptor.parseServerIpAndPort(this.connection, span);
        span.start();
        return null;
    }

    public <T extends Resultset> T postProcess(Supplier<String> sql, Query interceptedQuery, T originalResultSet, ServerSession serverSession) {
        if (this.interceptingExceptions && originalResultSet == null) {
            return null;
        }
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return null;
        }
        span.finish();
        return null;
    }

    static void parseServerIpAndPort(MysqlConnection connection, Span span) {
        try {
            URI url = URI.create(connection.getURL().substring(5));
            String remoteServiceName = connection.getProperties().getProperty("zipkinServiceName");
            if (remoteServiceName == null || "".equals(remoteServiceName)) {
                String databaseName = TracingQueryInterceptor.getDatabaseName(connection);
                remoteServiceName = databaseName != null && !databaseName.isEmpty() ? "mysql-" + databaseName : "mysql";
            }
            span.remoteServiceName(remoteServiceName);
            String host = TracingQueryInterceptor.getHost(connection);
            if (host != null) {
                span.remoteIpAndPort(host, url.getPort() == -1 ? 3306 : url.getPort());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getDatabaseName(MysqlConnection connection) throws SQLException {
        if (connection instanceof JdbcConnection) {
            return ((JdbcConnection)connection).getCatalog();
        }
        return "";
    }

    private static String getHost(MysqlConnection connection) {
        if (!(connection instanceof JdbcConnection)) {
            return null;
        }
        return ((JdbcConnection)connection).getHost();
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public QueryInterceptor init(MysqlConnection mysqlConnection, Properties properties, Log log) {
        String exceptionInterceptors = properties.getProperty("exceptionInterceptors");
        TracingQueryInterceptor interceptor = new TracingQueryInterceptor();
        interceptor.connection = mysqlConnection;
        boolean bl = interceptor.interceptingExceptions = exceptionInterceptors != null && exceptionInterceptors.contains(TracingExceptionInterceptor.class.getName());
        if (!interceptor.interceptingExceptions) {
            log.logWarn((Object)"TracingExceptionInterceptor not enabled. It is highly recommended to enable it for error logging to Zipkin.");
        }
        return interceptor;
    }

    public void destroy() {
    }
}

