/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.servlet.internal;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.jakarta.servlet.HttpServletResponseWrapper;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ServletRuntime {
    private static final ServletRuntime SERVLET_RUNTIME = new Servlet5();

    public HttpServletResponse httpServletResponse(ServletResponse response) {
        return (HttpServletResponse)response;
    }

    public abstract int status(HttpServletResponse var1);

    public abstract boolean isAsync(HttpServletRequest var1);

    public abstract void handleAsync(HttpServerHandler<HttpServerRequest, HttpServerResponse> var1, HttpServletRequest var2, HttpServletResponse var3, Span var4);

    ServletRuntime() {
    }

    public static ServletRuntime get() {
        return SERVLET_RUNTIME;
    }

    static final class Servlet5
    extends ServletRuntime {
        Servlet5() {
        }

        @Override
        public boolean isAsync(HttpServletRequest request) {
            return request.isAsyncStarted();
        }

        @Override
        public int status(HttpServletResponse response) {
            return response.getStatus();
        }

        @Override
        public void handleAsync(HttpServerHandler<HttpServerRequest, HttpServerResponse> handler, HttpServletRequest request, HttpServletResponse response, Span span) {
            if (span.isNoop()) {
                return;
            }
            TracingAsyncListener listener = new TracingAsyncListener(handler, span);
            request.getAsyncContext().addListener((AsyncListener)listener, (ServletRequest)request, (ServletResponse)response);
        }

        static final class AsyncTimeoutException
        extends TimeoutException {
            AsyncTimeoutException(AsyncEvent e) {
                super("Timed out after " + e.getAsyncContext().getTimeout() + "ms");
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }

        static final class TracingAsyncListener
        implements AsyncListener {
            final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;
            final Span span;

            TracingAsyncListener(HttpServerHandler<HttpServerRequest, HttpServerResponse> handler, Span span) {
                this.handler = handler;
                this.span = span;
            }

            public void onComplete(AsyncEvent e) {
                HttpServletRequest req = (HttpServletRequest)e.getSuppliedRequest();
                Object sendHandled = req.getAttribute("brave.jakarta.servlet.TracingFilter$SendHandled");
                if (sendHandled instanceof AtomicBoolean && ((AtomicBoolean)sendHandled).compareAndSet(false, true)) {
                    HttpServletResponse res = (HttpServletResponse)e.getSuppliedResponse();
                    HttpServerResponse response = HttpServletResponseWrapper.create(req, res, e.getThrowable());
                    this.handler.handleSend(response, this.span);
                }
            }

            public void onTimeout(AsyncEvent e) {
                ServletRequest request = e.getSuppliedRequest();
                if (request.getAttribute("error") == null) {
                    request.setAttribute("error", (Object)new AsyncTimeoutException(e));
                }
            }

            public void onError(AsyncEvent e) {
                ServletRequest request = e.getSuppliedRequest();
                if (request.getAttribute("error") == null) {
                    request.setAttribute("error", (Object)e.getThrowable());
                }
            }

            public void onStartAsync(AsyncEvent e) {
                AsyncContext eventAsyncContext = e.getAsyncContext();
                if (eventAsyncContext != null) {
                    eventAsyncContext.addListener((AsyncListener)this, e.getSuppliedRequest(), e.getSuppliedResponse());
                }
            }

            public String toString() {
                return "TracingAsyncListener{" + this.span + "}";
            }
        }
    }
}

