/*
 * Decompiled with CFR 0.152.
 */
package brave.vertx.web;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.atomic.AtomicBoolean;

final class TracingRoutingContextHandler
implements Handler<RoutingContext> {
    final HttpServerHandler<brave.http.HttpServerRequest, HttpServerResponse> handler;
    final CurrentTraceContext currentTraceContext;

    TracingRoutingContextHandler(HttpTracing httpTracing) {
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
    }

    public void handle(RoutingContext context) {
        TracingHandler tracingHandler = (TracingHandler)context.get(TracingHandler.class.getName());
        if (tracingHandler != null) {
            if (!context.failed()) {
                context.addHeadersEndHandler((Handler)tracingHandler);
            }
            context.next();
            return;
        }
        Span span = this.handler.handleReceive((brave.http.HttpServerRequest)new HttpServerRequestWrapper(context.request()));
        TracingHandler handler = new TracingHandler(context, span);
        context.put(TracingHandler.class.getName(), (Object)handler);
        context.addHeadersEndHandler((Handler)handler);
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());){
            context.next();
        }
    }

    static final class HttpServerResponseWrapper
    extends HttpServerResponse {
        final RoutingContext context;
        HttpServerRequestWrapper request;

        HttpServerResponseWrapper(RoutingContext context) {
            this.context = context;
        }

        public RoutingContext unwrap() {
            return this.context;
        }

        public HttpServerRequestWrapper request() {
            if (this.request == null) {
                this.request = new HttpServerRequestWrapper(this.context.request());
            }
            return this.request;
        }

        public Throwable error() {
            return this.context.failure();
        }

        public int statusCode() {
            return this.context.response().getStatusCode();
        }

        public String route() {
            String httpRoute = this.context.currentRoute().getPath();
            return httpRoute != null ? httpRoute : "";
        }
    }

    static final class HttpServerRequestWrapper
    extends brave.http.HttpServerRequest {
        final HttpServerRequest delegate;

        HttpServerRequestWrapper(HttpServerRequest delegate) {
            this.delegate = delegate;
        }

        public HttpServerRequest unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.rawMethod();
        }

        public String path() {
            return this.delegate.path();
        }

        public String url() {
            return this.delegate.absoluteURI();
        }

        public String header(String name) {
            return this.delegate.headers().get(name);
        }

        public boolean parseClientIpAndPort(Span span) {
            if (this.parseClientIpFromXForwardedFor(span)) {
                return true;
            }
            SocketAddress addr = this.delegate.remoteAddress();
            return span.remoteIpAndPort(addr.host(), addr.port());
        }
    }

    class TracingHandler
    implements Handler<Void> {
        final RoutingContext context;
        final Span span;
        final AtomicBoolean finished = new AtomicBoolean();

        TracingHandler(RoutingContext context, Span span) {
            this.context = context;
            this.span = span;
        }

        public void handle(Void aVoid) {
            if (!this.finished.compareAndSet(false, true)) {
                return;
            }
            TracingRoutingContextHandler.this.handler.handleSend((HttpServerResponse)new HttpServerResponseWrapper(this.context), this.span);
        }
    }
}

