/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver.brave;

import brave.Span;
import brave.Tag;
import brave.handler.MutableSpan;
import com.google.common.net.InetAddresses;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.Span;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Map;
import zipkin2.reporter.stackdriver.brave.SpanUtil;

final class AttributesExtractor {
    private static final String kAgentLabelKey = "/agent";
    private static final String kComponentLabelKey = "/component";
    private static final String kKindLabelKey = "/kind";
    private final Tag<Throwable> errorTag;
    private final Map<String, String> renamedLabels;

    AttributesExtractor(Tag<Throwable> errorTag, Map<String, String> renamedLabels) {
        this.errorTag = errorTag;
        this.renamedLabels = renamedLabels;
    }

    Span.Attributes extract(MutableSpan braveSpan) {
        String errorValue;
        Span.Attributes.Builder attributes = Span.Attributes.newBuilder();
        if (braveSpan.kind() != null) {
            attributes.putAttributeMap(kKindLabelKey, AttributesExtractor.toAttributeValue(this.kindLabel(braveSpan.kind())));
        }
        if ((errorValue = this.errorTag.value((Object)braveSpan.error(), null)) != null) {
            attributes.putAttributeMap(this.getLabelName("error"), AttributesExtractor.toAttributeValue(errorValue));
        }
        braveSpan.forEachTag(this::addTag, (Object)attributes);
        if (braveSpan.localServiceName() != null && braveSpan.kind() == Span.Kind.SERVER && braveSpan.localIp() != null) {
            InetAddress ip = InetAddresses.forString((String)braveSpan.localIp());
            if (ip instanceof Inet4Address) {
                attributes.putAttributeMap(this.getLabelName("endpoint.ipv4"), AttributesExtractor.toAttributeValue(ip.getHostAddress()));
            } else if (ip instanceof Inet6Address) {
                attributes.putAttributeMap(this.getLabelName("endpoint.ipv6"), AttributesExtractor.toAttributeValue(ip.getHostAddress()));
            }
        }
        if (braveSpan.localServiceName() != null && !braveSpan.localServiceName().isEmpty()) {
            attributes.putAttributeMap(kComponentLabelKey, AttributesExtractor.toAttributeValue(braveSpan.localServiceName()));
        }
        if (braveSpan.parentId() == null) {
            String agentName = System.getProperty("stackdriver.trace.zipkin.agent", "zipkin-java");
            attributes.putAttributeMap(kAgentLabelKey, AttributesExtractor.toAttributeValue(agentName));
        }
        return attributes.build();
    }

    void addTag(Span.Attributes.Builder target, String key, String value) {
        target.putAttributeMap(this.getLabelName(key), AttributesExtractor.toAttributeValue(value));
    }

    static AttributeValue toAttributeValue(String text) {
        return AttributeValue.newBuilder().setStringValue(SpanUtil.toTruncatableString(text)).build();
    }

    private String getLabelName(String zipkinName) {
        String renamed = this.renamedLabels.get(zipkinName);
        return renamed != null ? renamed : zipkinName;
    }

    private String kindLabel(Span.Kind kind) {
        switch (kind) {
            case CLIENT: {
                return "client";
            }
            case SERVER: {
                return "server";
            }
            case PRODUCER: {
                return "producer";
            }
            case CONSUMER: {
                return "consumer";
            }
        }
        return kind.name().toLowerCase();
    }
}

