/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver.brave;

import brave.Tag;
import brave.handler.MutableSpan;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.protobuf.Timestamp;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.reporter.stackdriver.brave.AttributesExtractor;
import zipkin2.reporter.stackdriver.brave.SpanUtil;

final class SpanTranslator {
    private static final Logger LOG = Logger.getLogger(SpanTranslator.class.getName());
    private static final Map<String, String> RENAMED_LABELS = new LinkedHashMap<String, String>();
    private static final Map<String, String> SPRING6_RENAMED_HTTP_LABELS;
    private final AttributesExtractor attributesExtractor;

    SpanTranslator(Tag<Throwable> errorTag) {
        this.attributesExtractor = new AttributesExtractor(errorTag, RENAMED_LABELS);
    }

    Span.Builder translate(Span.Builder spanBuilder, MutableSpan braveSpan) {
        boolean logTranslation = LOG.isLoggable(Level.FINE);
        if (logTranslation) {
            LOG.log(Level.FINE, ">> translating zipkin span: {0}", braveSpan);
        }
        spanBuilder.setSpanId(braveSpan.id());
        if (braveSpan.parentId() != null) {
            spanBuilder.setParentSpanId(braveSpan.parentId());
        }
        spanBuilder.setDisplayName(SpanUtil.toTruncatableString(braveSpan.name() != null && !braveSpan.name().isEmpty() ? braveSpan.name() : "unknown"));
        if (braveSpan.startTimestamp() != 0L) {
            spanBuilder.setStartTime(SpanTranslator.createTimestamp(braveSpan.startTimestamp()));
            if (braveSpan.finishTimestamp() != 0L) {
                spanBuilder.setEndTime(SpanTranslator.createTimestamp(braveSpan.finishTimestamp()));
            }
        }
        spanBuilder.setAttributes(this.attributesExtractor.extract(braveSpan));
        if (braveSpan.name() != null && braveSpan.name().contains("http")) {
            braveSpan.tags().forEach((key, value) -> {
                if (SPRING6_RENAMED_HTTP_LABELS.containsKey(key)) {
                    spanBuilder.getAttributesBuilder().putAttributeMap(SPRING6_RENAMED_HTTP_LABELS.get(key), AttributesExtractor.toAttributeValue(value));
                }
            });
        }
        if (braveSpan.annotationCount() > 0) {
            Span.TimeEvents.Builder events = Span.TimeEvents.newBuilder();
            braveSpan.forEachAnnotation(SpanTranslator::addAnnotation, (Object)events);
            spanBuilder.setTimeEvents(events);
        }
        if (logTranslation) {
            LOG.log(Level.FINE, "<< translated to stackdriver span: {0}", spanBuilder);
        }
        return spanBuilder;
    }

    static void addAnnotation(Span.TimeEvents.Builder target, long timestamp, String value) {
        target.addTimeEvent(Span.TimeEvent.newBuilder().setTime(SpanTranslator.createTimestamp(timestamp)).setAnnotation(Span.TimeEvent.Annotation.newBuilder().setDescription(SpanUtil.toTruncatableString(value))));
    }

    static Timestamp createTimestamp(long microseconds) {
        long seconds = microseconds / 1000000L;
        int remainderMicros = (int)(microseconds % 1000000L);
        int remainderNanos = remainderMicros * 1000;
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(remainderNanos).build();
    }

    static {
        RENAMED_LABELS.put("http.host", "/http/host");
        RENAMED_LABELS.put("http.method", "/http/method");
        RENAMED_LABELS.put("http.status_code", "/http/status_code");
        RENAMED_LABELS.put("http.request.size", "/request/size");
        RENAMED_LABELS.put("http.response.size", "/response/size");
        RENAMED_LABELS.put("http.url", "/http/url");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("status", "/http/status_code");
        map.put("method", "/http/method");
        SPRING6_RENAMED_HTTP_LABELS = Collections.unmodifiableMap(map);
    }
}

