/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.stackdriver;

import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.stackdriver.XCloudTraceContextExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StackdriverTracePropagation
implements Propagation<String> {
    public static final String TRACE_ID_NAME = "x-cloud-trace-context";
    final Propagation<String> primary;
    final List<String> keyNames;

    public static Propagation.Factory newFactory(Propagation.Factory primary) {
        if (primary == null) {
            throw new NullPointerException("primary == null");
        }
        return new Factory(primary);
    }

    StackdriverTracePropagation(Propagation<String> primary) {
        this.primary = primary;
        ArrayList<String> keyNames = new ArrayList<String>(primary.keys());
        keyNames.add(TRACE_ID_NAME);
        this.keyNames = Collections.unmodifiableList(keyNames);
    }

    public List<String> keys() {
        return this.keyNames;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return this.primary.injector(setter);
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return new XCloudTraceContextExtractor<R>(this.primary, getter);
    }

    static final class Factory
    extends Propagation.Factory {
        final Propagation.Factory primary;

        Factory(Propagation.Factory primary) {
            this.primary = primary;
        }

        public Propagation<String> get() {
            return new StackdriverTracePropagation((Propagation<String>)this.primary.get());
        }

        public boolean supportsJoin() {
            return false;
        }

        public boolean requires128BitTraceId() {
            return true;
        }

        public TraceContext decorate(TraceContext context) {
            return this.primary.decorate(context);
        }
    }
}

