/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver.internal;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

final class AwaitableUnaryClientCallListener<V>
extends ClientCall.Listener<V> {
    final CountDownLatch countDown = new CountDownLatch(1);
    boolean resultSet;
    Object result;
    long serverTimeoutMs;

    AwaitableUnaryClientCallListener(long serverTimeoutMs) {
        if (serverTimeoutMs <= 0L) {
            throw new IllegalArgumentException("Server response timeout must be greater than 0");
        }
        this.serverTimeoutMs = serverTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    V await() throws IOException {
        boolean interrupted = false;
        while (true) {
            try {
                Object object;
                while (true) {
                    if (!this.countDown.await(this.serverTimeoutMs, TimeUnit.MILLISECONDS)) {
                        throw new IllegalStateException("timeout waiting for onClose. timeoutMs=" + this.serverTimeoutMs + ", resultSet=" + this.resultSet);
                    }
                    object = this;
                    // MONITORENTER : object
                    if (this.resultSet) break;
                    // MONITOREXIT : object
                }
                Object result = this.result;
                // MONITOREXIT : object
                if (result instanceof Throwable) {
                    if (result instanceof Error) {
                        throw (Error)result;
                    }
                    if (result instanceof IOException) {
                        throw (IOException)result;
                    }
                    if (!(result instanceof RuntimeException)) throw new RuntimeException((Throwable)result);
                    throw (RuntimeException)result;
                }
                object = result;
                return (V)object;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void onHeaders(Metadata headers) {
    }

    public synchronized void onMessage(V value) {
        if (this.resultSet) {
            throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
        }
        this.result = value;
        this.resultSet = true;
    }

    public synchronized void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            if (!this.resultSet) {
                this.result = Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException(trailers);
            }
        } else {
            this.result = status.asRuntimeException(trailers);
        }
        this.resultSet = true;
        this.countDown.countDown();
    }
}

