/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.derby;

import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.derby.DerbyEmbeddedDatabase;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public class DerbyDatabaseProvider
implements DatabaseProvider {
    private static final String URL_TEMPLATE = "jdbc:derby:memory:%s;%s";

    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource();
        String databaseName = UUID.randomUUID().toString();
        dataSource.setDriverClass(EmbeddedDriver.class);
        dataSource.setUrl(String.format(URL_TEMPLATE, databaseName, "create=true"));
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        DerbyEmbeddedDatabase database = new DerbyEmbeddedDatabase((DataSource)dataSource, databaseName, () -> DerbyDatabaseProvider.shutdownDatabase(databaseName));
        try {
            if (preparer != null) {
                preparer.prepare(database);
            }
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
        return database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(DerbyDatabaseProvider.class);
    }

    private static void shutdownDatabase(String dbName) {
        CompletableFuture.runAsync(() -> {
            try {
                new EmbeddedDriver().connect(String.format(URL_TEMPLATE, dbName, "drop=true"), new Properties());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }
}

