/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import io.zonky.test.db.postgres.embedded.DatabasePreparer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

public final class FlywayPreparer
implements DatabasePreparer {
    private final FluentConfiguration flyway;
    private final List<String> locations;

    public static FlywayPreparer forClasspathLocation(String ... locations) {
        FluentConfiguration f = Flyway.configure().locations(locations);
        return new FlywayPreparer(f, Arrays.asList(locations));
    }

    private FlywayPreparer(FluentConfiguration flyway, List<String> locations) {
        this.flyway = flyway;
        this.locations = locations;
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        this.flyway.dataSource(ds);
        this.flyway.load().migrate();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlywayPreparer)) {
            return false;
        }
        return Objects.equals(this.locations, ((FlywayPreparer)obj).locations);
    }

    public int hashCode() {
        return Objects.hashCode(this.locations);
    }
}

