/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceType {
    PROPERTIES(".properties"),
    YAML(".yml", ".yaml");

    private final Set<String> fileExtensions = new HashSet<String>();

    private ResourceType(String ... fileExtensions) {
        for (String fileExtension : fileExtensions) {
            this.fileExtensions.add(fileExtension);
        }
    }

    public static Set<String> allFileExtensions(ResourceType ... resourceTypes) {
        HashSet<String> extensions = new HashSet<String>();
        for (ResourceType resourceType : resourceTypes) {
            extensions.addAll(resourceType.fileExtensions());
        }
        return extensions;
    }

    public static ResourceType getByFileName(String fileName) {
        for (ResourceType resourceType : ResourceType.values()) {
            for (String extension : resourceType.fileExtensions()) {
                if (!fileName.endsWith(extension)) continue;
                return resourceType;
            }
        }
        return null;
    }

    public Set<String> fileExtensions() {
        return new HashSet<String>(this.fileExtensions);
    }
}

