/*
	* Copyright (C) 2003-2017 Sebastiano Vigna
	*
	* Licensed under the Apache License, Version 2.0 (the "License");
	* you may not use this file except in compliance with the License.
	* You may obtain a copy of the License at
	*
	*     http://www.apache.org/licenses/LICENSE-2.0
	*
	* Unless required by applicable law or agreed to in writing, software
	* distributed under the License is distributed on an "AS IS" BASIS,
	* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	* See the License for the specific language governing permissions and
	* limitations under the License.
	*/
package it.unimi.dsi.fastutil.shorts;

/**
 * An abstract class providing basic methods for sorted sets implementing a
 * type-specific interface.
 */
public abstract class AbstractShortSortedSet extends AbstractShortSet implements ShortSortedSet {
	protected AbstractShortSortedSet() {
	}

	/**
	 * {@inheritDoc}
	 *
	 * <p>
	 * This implementation delegates to the new covariantly stronger generic
	 * method {@link #iterator()}.
	 * 
	 * @deprecated As of <code>fastutil</code> 5, replaced by
	 *             {@link #iterator()}.
	 */
	@Deprecated
	@Override
	public ShortBidirectionalIterator shortIterator() {
		return iterator();
	}

	@Override
	public abstract ShortBidirectionalIterator iterator();

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public ShortSortedSet headSet(final Short to) {
		return headSet(to.shortValue());
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public ShortSortedSet tailSet(final Short from) {
		return tailSet(from.shortValue());
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public ShortSortedSet subSet(final Short from, final Short to) {
		return subSet(from.shortValue(), to.shortValue());
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public Short first() {
		return (Short.valueOf(firstShort()));
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public Short last() {
		return (Short.valueOf(lastShort()));
	}
}
