/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class DefaultTicketRegistryCleaner
implements RegistryCleaner,
InitializingBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private TicketRegistry ticketRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Collection ticketsInCache;
        ArrayList<Ticket> ticketsToRemove = new ArrayList<Ticket>();
        this.log.info((Object)("Starting cleaning of expired tickets from ticket registry at [" + new Date() + "]"));
        TicketRegistry ticketRegistry = this.ticketRegistry;
        synchronized (ticketRegistry) {
            ticketsInCache = this.ticketRegistry.getTickets();
        }
        Iterator iter = ticketsInCache.iterator();
        while (iter.hasNext()) {
            Ticket ticket = (Ticket)iter.next();
            if (!ticket.isExpired()) continue;
            ticketsToRemove.add(ticket);
        }
        ticketRegistry = this.ticketRegistry;
        synchronized (ticketRegistry) {
            this.log.info((Object)(ticketsToRemove.size() + " found to be removed.  Removing now."));
            Iterator iter2 = ticketsToRemove.iterator();
            while (iter2.hasNext()) {
                Ticket ticket = (Ticket)iter2.next();
                this.ticketRegistry.deleteTicket(ticket.getId());
            }
        }
        this.log.info((Object)("Finished cleaning of expired tickets from ticket registry at [" + new Date() + "]"));
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ticketRegistry, (String)"ticketRegistry cannot be null.");
    }
}

