/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.web.util.WebUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.CookieGenerator;

public final class LogoutController
extends AbstractController
implements InitializingBean {
    private CentralAuthenticationService centralAuthenticationService;
    private CookieGenerator ticketGrantingTicketCookieGenerator;
    private CookieGenerator warnCookieGenerator;
    private String logoutView;
    private boolean followServiceRedirects;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.centralAuthenticationService, (String)("centralAuthenticationService must be set on " + ((Object)((Object)this)).getClass().getName()));
        Assert.notNull((Object)this.ticketGrantingTicketCookieGenerator, (String)"ticketGrantingTicketCookieGenerator cannot be null");
        Assert.notNull((Object)this.warnCookieGenerator, (String)"warnCookieGenerator cannot be null");
        Assert.hasText((String)this.logoutView, (String)"logoutView must have text.");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticketGrantingTicketId = WebUtils.getCookieValue(request, this.ticketGrantingTicketCookieGenerator.getCookieName());
        String service = request.getParameter("service");
        if (ticketGrantingTicketId != null) {
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
            this.ticketGrantingTicketCookieGenerator.removeCookie(response);
            this.warnCookieGenerator.removeCookie(response);
        }
        if (this.followServiceRedirects && service != null) {
            return new ModelAndView((View)new RedirectView(service));
        }
        return new ModelAndView(this.logoutView);
    }

    public void setTicketGrantingTicketCookieGenerator(CookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setFollowServiceRedirects(boolean followServiceRedirects) {
        this.followServiceRedirects = followServiceRedirects;
    }

    public void setLogoutView(String logoutView) {
        this.logoutView = logoutView;
    }
}

