/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;

public final class ContextUtils {
    private ContextUtils() {
    }

    public static HttpServletRequest getHttpServletRequest(RequestContext context) {
        if (context.getExternalContext().getClass().equals(ServletExternalContext.class)) {
            return ((ServletExternalContext)context.getExternalContext()).getRequest();
        }
        throw new IllegalStateException("Cannot obtain HttpServletRequest from event of type: " + context.getExternalContext().getClass().getName());
    }

    public static HttpServletResponse getHttpServletResponse(RequestContext context) {
        if (context.getExternalContext().getClass().equals(ServletExternalContext.class)) {
            return ((ServletExternalContext)context.getExternalContext()).getResponse();
        }
        throw new IllegalStateException("Cannot obtain HttpServletResponse from event of type: " + context.getExternalContext().getClass().getName());
    }

    public static void addAttribute(RequestContext context, String attributeName, Object attribute) {
        context.getRequestScope().put(attributeName, attribute);
    }

    public static Object getAttribute(RequestContext context, String attributeName) {
        return context.getRequestScope().get(attributeName);
    }

    public static String getParameterAsString(RequestContext context, String parameterName) {
        return context.getExternalContext().getRequestParameterMap().get(parameterName);
    }

    public static boolean getParameterAsBoolean(RequestContext context, String parameterName) {
        return StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get(parameterName));
    }
}

