/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleError;

public abstract class JingleNegotiator {
    private State state;
    private XMPPConnection connection;
    private final ArrayList listeners = new ArrayList();
    private String expectedAckId;

    public JingleNegotiator() {
        this(null);
    }

    public JingleNegotiator(XMPPConnection connection) {
        this.connection = connection;
        this.state = null;
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }

    public boolean invalidState() {
        return this.state == null;
    }

    public State getState() {
        return this.state;
    }

    public Class getStateClass() {
        if (this.state != null) {
            return this.state.getClass();
        }
        return Object.class;
    }

    protected void setState(State newState) {
        boolean transition;
        boolean bl = transition = newState != this.state;
        if (transition && this.state != null) {
            this.state.eventExit();
        }
        this.state = newState;
        if (transition && this.state != null) {
            this.state.eventEnter();
        }
    }

    public void addExpectedId(String id) {
        this.expectedAckId = id;
    }

    public boolean isExpectedId(String id) {
        if (id != null) {
            return id.equals(this.expectedAckId);
        }
        return false;
    }

    public void removeExpectedId(String id) {
        this.addExpectedId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JingleListener li) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JingleListener li) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getListenersList() {
        ArrayList result;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            result = new ArrayList(this.listeners);
        }
        return result;
    }

    public abstract IQ dispatchIncomingPacket(IQ var1, String var2) throws XMPPException;

    public void close() {
        this.setState(null);
    }

    public static class State {
        private JingleNegotiator neg;

        public State(JingleNegotiator neg) {
            this.neg = neg;
        }

        public JingleNegotiator getNegotiator() {
            return this.neg;
        }

        public void setNegotiator(JingleNegotiator neg) {
            this.neg = neg;
        }

        public Jingle eventAck(IQ iq) throws XMPPException {
            return null;
        }

        public void eventError(IQ iq) throws XMPPException {
            throw new JingleException(iq.getError().getMessage());
        }

        public Jingle eventInvite() throws XMPPException {
            throw new IllegalStateException("Negotiation can not be started in this state.");
        }

        public Jingle eventInitiate(Jingle jin) throws XMPPException {
            return null;
        }

        public Jingle eventAccept(Jingle jin) throws XMPPException {
            return null;
        }

        public Jingle eventRedirect(Jingle jin) throws XMPPException {
            return null;
        }

        public Jingle eventModify(Jingle jin) throws XMPPException {
            return null;
        }

        public Jingle eventDecline(Jingle jin) throws XMPPException {
            return null;
        }

        public Jingle eventInfo(Jingle jin) throws XMPPException {
            return null;
        }

        public Jingle eventTerminate(Jingle jin) throws XMPPException {
            if (this.neg != null && !this.neg.invalidState()) {
                this.neg.close();
            }
            return null;
        }

        public void eventEnter() {
        }

        public void eventExit() {
            if (this.neg != null) {
                this.neg.removeExpectedId(null);
            }
        }
    }

    public static class JingleException
    extends XMPPException {
        private final JingleError error;

        public JingleException() {
            this.error = null;
        }

        public JingleException(String msg) {
            super(msg);
            this.error = null;
        }

        public JingleException(JingleError error) {
            this.error = error;
        }

        public JingleError getError() {
            return this.error;
        }
    }
}

