/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.mediaimpl.sshare;

import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jivesoftware.smackx.jingle.IncomingJingleSession;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.mediaimpl.sshare.api.ImageDecoder;
import org.jivesoftware.smackx.jingle.mediaimpl.sshare.api.ImageEncoder;
import org.jivesoftware.smackx.jingle.mediaimpl.sshare.api.ImageReceiver;
import org.jivesoftware.smackx.jingle.mediaimpl.sshare.api.ImageTransmitter;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

public class ScreenShareSession
extends JingleMediaSession {
    private ImageTransmitter transmitter = null;
    private ImageReceiver receiver = null;
    private int width = 600;
    private int height = 600;

    public ScreenShareSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, String locator, JingleSession jingleSession) {
        super(payloadType, remote, local, "Screen", jingleSession);
        this.initialize();
    }

    public void initialize() {
        if (this.getJingleSession() instanceof IncomingJingleSession) {
            JFrame window = new JFrame();
            JPanel jp = new JPanel();
            window.add(jp);
            window.setLocation(0, 0);
            window.setSize(600, 600);
            window.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    ScreenShareSession.this.receiver.stop();
                }
            });
            try {
                this.receiver = new ImageReceiver(InetAddress.getByName("0.0.0.0"), this.getRemote().getPort(), this.getLocal().getPort(), this.width, this.height);
                System.out.println("Receiving on:" + this.receiver.getLocalPort());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            jp.add(this.receiver);
            this.receiver.setVisible(true);
            window.setAlwaysOnTop(true);
            window.setVisible(true);
        } else {
            try {
                InetAddress remote = InetAddress.getByName(this.getRemote().getIp());
                this.transmitter = new ImageTransmitter(new DatagramSocket(this.getLocal().getPort()), remote, this.getRemote().getPort(), new Rectangle(0, 0, this.width, this.height));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void startTrasmit() {
        new Thread(this.transmitter).start();
    }

    public void setTrasmit(boolean active) {
        this.transmitter.setTransmit(true);
    }

    public void startReceive() {
    }

    public void stopTrasmit() {
        if (this.transmitter != null) {
            this.transmitter.stop();
        }
    }

    public void stopReceive() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
    }

    protected int getFreePort() {
        int freePort = 0;
        for (int i = 0; i < 10; ++i) {
            freePort = (int)(10000L + Math.round(Math.random() * 10000.0));
            freePort = freePort % 2 == 0 ? freePort : freePort + 1;
            try {
                ServerSocket ss = new ServerSocket(freePort);
                freePort = ss.getLocalPort();
                ss.close();
                return freePort;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(0);
            freePort = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return freePort;
    }

    public void setEncoder(ImageEncoder encoder) {
        if (encoder != null) {
            this.transmitter.setEncoder(encoder);
        }
    }

    public void setDecoder(ImageDecoder decoder) {
        if (decoder != null) {
            this.receiver.setDecoder(decoder);
        }
    }
}

