/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jivesoftware.smackx.jingle.nat.ResultListener;
import org.jivesoftware.smackx.jingle.nat.TestResult;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICECandidate
extends TransportCandidate
implements Comparable {
    private String id;
    private String username;
    private int preference;
    private TransportCandidate.Protocol proto;
    private TransportCandidate.Channel channel;
    private int network;
    private Type type;

    public ICECandidate() {
    }

    public ICECandidate(String ip, int generation, int network, String password, int port, String username, int preference, Type type) {
        super(ip, port, generation);
        this.proto = TransportCandidate.Protocol.UDP;
        this.channel = TransportCandidate.Channel.MYRTPVOICE;
        this.network = network;
        this.password = password;
        this.username = username;
        this.preference = preference;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransportCandidate.Protocol getProto() {
        return this.proto;
    }

    public void setProto(TransportCandidate.Protocol proto) {
        this.proto = proto;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int network) {
        this.network = network;
    }

    public String getUsername() {
        return this.username;
    }

    public TransportCandidate.Channel getChannel() {
        return this.channel;
    }

    public void setChannel(TransportCandidate.Channel channel) {
        this.channel = channel;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getPreference() {
        return this.preference;
    }

    public void setPreference(int preference) {
        this.preference = preference;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void check(final List<TransportCandidate> localCandidates) {
        final ICECandidate checkingCandidate = this;
        Thread checkThread = new Thread(new Runnable(){

            public void run() {
                TransportCandidate.CandidateEcho echo;
                final TestResult result = new TestResult();
                if (ICECandidate.this.getType().equals("relay")) {
                    ICECandidate.this.triggerCandidateChecked(false);
                    return;
                }
                ResultListener resultListener = new ResultListener(){

                    public void testFinished(TestResult testResult, TransportCandidate candidate) {
                        if (testResult.isReachable() && checkingCandidate.equals(candidate)) {
                            result.setResult(true);
                            System.out.println("RESULT>>>OK:" + candidate.getIp() + ":" + candidate.getPort());
                        }
                    }
                };
                for (TransportCandidate candidate : localCandidates) {
                    ICECandidate iceCandidate;
                    echo = candidate.getCandidateEcho();
                    if (echo == null || !(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals((Object)ICECandidate.this.getType())) continue;
                    try {
                        echo.addResultListener(resultListener);
                        InetAddress address = InetAddress.getByName(ICECandidate.this.getIp());
                        echo.testASync(checkingCandidate, ICECandidate.this.getPassword());
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
                for (int i = 0; i < 10 && !result.isReachable(); ++i) {
                    try {
                        System.err.println(i);
                        Thread.sleep(400L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                for (TransportCandidate candidate : localCandidates) {
                    echo = candidate.getCandidateEcho();
                    if (echo == null) continue;
                    echo.removeResultListener(resultListener);
                }
                ICECandidate.this.triggerCandidateChecked(result.isReachable());
            }
        }, "Transport candidate check");
        checkThread.setName("Transport candidate test");
        checkThread.start();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICECandidate other = (ICECandidate)obj;
        if (this.getChannel() == null ? other.getChannel() != null : !this.getChannel().equals(other.getChannel())) {
            return false;
        }
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        if (this.getNetwork() != other.getNetwork()) {
            return false;
        }
        if (this.getPassword() == null ? other.getPassword() != null : !this.getPassword().equals(other.password)) {
            return false;
        }
        if (this.getPreference() != other.getPreference()) {
            return false;
        }
        if (this.getProto() == null ? other.getProto() != null : !this.getProto().equals(other.getProto())) {
            return false;
        }
        if (this.getUsername() == null ? other.getUsername() != null : !this.getUsername().equals(other.getUsername())) {
            return false;
        }
        if (this.getIp() == null ? other.getIp() != null : !this.getIp().equals(other.getIp())) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return !(this.getType() == null ? other.getType() != null : !this.getType().equals((Object)other.getType()));
    }

    @Override
    public boolean isNull() {
        if (super.isNull()) {
            return true;
        }
        if (this.getProto().isNull()) {
            return true;
        }
        return this.getChannel().isNull();
    }

    public int compareTo(Object arg) {
        if (arg instanceof ICECandidate) {
            ICECandidate tc = (ICECandidate)arg;
            if (this.getPreference() < tc.getPreference()) {
                return -1;
            }
            if (this.getPreference() > tc.getPreference()) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        relay,
        srflx,
        prflx,
        local,
        host;

    }
}

