/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;

public class TcpUdpBridgeClient {
    private String remoteTcpHost = null;
    private String remoteUdpHost = null;
    private int remoteTcpPort = -1;
    private int remoteUdpPort = -1;
    private int localUdpPort = -1;
    private DatagramSocket localUdpSocket;
    private Socket localTcpSocket;

    public TcpUdpBridgeClient(String remoteTcpHost, String remoteUdpHost, int remoteTcpPort, int remoteUdpPort) {
        this.remoteTcpHost = remoteTcpHost;
        this.remoteUdpHost = remoteUdpHost;
        this.remoteTcpPort = remoteTcpPort;
        this.remoteUdpPort = remoteUdpPort;
        try {
            this.localTcpSocket = new Socket(remoteTcpHost, remoteTcpPort);
            this.localUdpSocket = new DatagramSocket(0);
            this.localUdpPort = this.localUdpSocket.getLocalPort();
            System.out.println("UDP: " + this.localUdpSocket.getLocalPort());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.startBridge();
    }

    public void startBridge() {
        final Thread process = new Thread(new Runnable(){

            public void run() {
                try {
                    OutputStream out = TcpUdpBridgeClient.this.localTcpSocket.getOutputStream();
                    while (true) {
                        byte[] b = new byte[500];
                        DatagramPacket p = new DatagramPacket(b, 500);
                        TcpUdpBridgeClient.this.localUdpSocket.receive(p);
                        if (p.getLength() == 0) continue;
                        System.out.println("UDP Client Received and Sending to TCP Server:" + new String(p.getData(), 0, p.getLength(), "UTF-8"));
                        out.write(p.getData(), 0, p.getLength());
                        out.flush();
                        System.out.println("Client Flush");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        new Thread(new Runnable(){

            public void run() {
                try {
                    InputStream in = TcpUdpBridgeClient.this.localTcpSocket.getInputStream();
                    InetAddress remoteHost = InetAddress.getByName(TcpUdpBridgeClient.this.remoteUdpHost);
                    process.start();
                    while (true) {
                        byte[] b = new byte[500];
                        int s = in.read(b);
                        System.out.println("TCP Client:" + new String(b, 0, s, "UTF-8"));
                        DatagramPacket udpPacket = new DatagramPacket(b, s);
                        udpPacket.setAddress(remoteHost);
                        udpPacket.setPort(TcpUdpBridgeClient.this.remoteUdpPort);
                        TcpUdpBridgeClient.this.localUdpSocket.send(udpPacket);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    public Socket getLocalTcpSocket() {
        return this.localTcpSocket;
    }

    public DatagramSocket getLocalUdpSocket() {
        return this.localUdpSocket;
    }
}

