/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContentDescription;
import org.jivesoftware.smackx.packet.JingleContentInfo;
import org.jivesoftware.smackx.packet.JingleTransport;
import org.jivesoftware.smackx.provider.JingleContentDescriptionProvider;
import org.jivesoftware.smackx.provider.JingleContentInfoProvider;
import org.jivesoftware.smackx.provider.JingleTransportProvider;
import org.xmlpull.v1.XmlPullParser;

public class JingleProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        Jingle jingle = new Jingle();
        String sid = "";
        String initiator = "";
        String responder = "";
        boolean done = false;
        JingleContentDescriptionProvider.Audio jdpAudio = new JingleContentDescriptionProvider.Audio();
        JingleTransportProvider.RawUdp jtpRawUdp = new JingleTransportProvider.RawUdp();
        JingleTransportProvider.Ice jtpIce = new JingleTransportProvider.Ice();
        JingleContentInfoProvider.Audio jmipAudio = new JingleContentInfoProvider.Audio();
        sid = parser.getAttributeValue("", "sid");
        Jingle.Action action = Jingle.Action.getAction(parser.getAttributeValue("", "action"));
        initiator = parser.getAttributeValue("", "initiator");
        responder = parser.getAttributeValue("", "responder");
        jingle.setSid(sid);
        jingle.setAction(action);
        jingle.setInitiator(initiator);
        jingle.setResponder(responder);
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("description") && namespace.equals("http://jabber.org/protocol/jingle/description/audio")) {
                    jingle.addDescription((JingleContentDescription)jdpAudio.parseExtension(parser));
                    continue;
                }
                if (elementName.equals("transport")) {
                    if (namespace.equals("http://jabber.org/protocol/jingle/transport/raw-udp")) {
                        jingle.addTransport((JingleTransport)jtpRawUdp.parseExtension(parser));
                        continue;
                    }
                    if (namespace.equals("http://jabber.org/protocol/jingle/transport/ice")) {
                        jingle.addTransport((JingleTransport)jtpIce.parseExtension(parser));
                        continue;
                    }
                    throw new XMPPException("Unknown transport namespace \"" + namespace + "\" in Jingle packet.");
                }
                if (namespace.equals("http://jabber.org/protocol/jingle/info/audio")) {
                    jingle.setContentInfo((JingleContentInfo)((JingleContentInfoProvider)jmipAudio).parseExtension(parser));
                    continue;
                }
                if (elementName.equals("content")) continue;
                throw new XMPPException("Unknown combination of namespace \"" + namespace + "\" and element name \"" + elementName + "\" in Jingle packet.");
            }
            if (eventType != 3 || !parser.getName().equals(Jingle.getElementName())) continue;
            done = true;
        }
        return jingle;
    }
}

