/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.CompositeComponentExpressionHolder;
import jakarta.faces.validator.MessageFactory;
import jakarta.faces.validator.MultiFieldValidationUtils;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.groups.Default;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanValidator
implements Validator,
PartialStateHolder {
    private static final Logger LOGGER = Logger.getLogger("jakarta.faces.validator", "jakarta.faces.LogStrings");
    private String validationGroups;
    private transient Class<?>[] cachedValidationGroups;
    public static final String VALIDATOR_ID = "jakarta.faces.Bean";
    public static final String MESSAGE_ID = "jakarta.faces.validator.BeanValidator.MESSAGE";
    public static final String VALIDATOR_FACTORY_KEY = "jakarta.faces.validator.beanValidator.ValidatorFactory";
    public static final String VALIDATION_GROUPS_DELIMITER = ",";
    public static final String EMPTY_VALIDATION_GROUPS_PATTERN = "^[\\W,]*$";
    public static final String DISABLE_DEFAULT_BEAN_VALIDATOR_PARAM_NAME = "jakarta.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR";
    public static final String ENABLE_VALIDATE_WHOLE_BEAN_PARAM_NAME = "jakarta.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN";
    private boolean initialState;
    private boolean transientValue;

    public void setValidationGroups(String validationGroups) {
        this.clearInitialState();
        String newValidationGroups = validationGroups;
        if (newValidationGroups != null && newValidationGroups.matches(EMPTY_VALIDATION_GROUPS_PATTERN)) {
            newValidationGroups = null;
        }
        if (newValidationGroups == null && validationGroups != null) {
            this.cachedValidationGroups = null;
        }
        if (newValidationGroups != null && validationGroups != null && !newValidationGroups.equals(validationGroups)) {
            this.cachedValidationGroups = null;
        }
        if (newValidationGroups != null && validationGroups == null) {
            this.cachedValidationGroups = null;
        }
        this.validationGroups = newValidationGroups;
    }

    public String getValidationGroups() {
        return this.validationGroups;
    }

    public void validate(FacesContext context, UIComponent component, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (component == null) {
            throw new NullPointerException();
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            return;
        }
        ValueReference valueReference = BeanValidator.getValueReference(context, component, valueExpression);
        if (valueReference == null || valueReference.getBase() == null) {
            return;
        }
        Class[] validationGroupsArray = this.parseValidationGroups(this.getValidationGroups());
        if (this.isResolvable(valueReference, valueExpression)) {
            jakarta.validation.Validator beanValidator = BeanValidator.getBeanValidator(context);
            Set violationsRaw = null;
            try {
                violationsRaw = beanValidator.validateValue(valueReference.getBase().getClass(), valueReference.getProperty().toString(), value, validationGroupsArray);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.fine("Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Unable to get value of expression.  Message from Bean Validation: " + iae.getMessage());
            }
            Set violations = violationsRaw;
            if (violations != null && !violations.isEmpty()) {
                ValidatorException toThrow;
                if (violations.size() == 1) {
                    ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
                    toThrow = new ValidatorException(MessageFactory.getMessage(context, MESSAGE_ID, violation.getMessage(), MessageFactory.getLabel(context, component)));
                } else {
                    LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(violations.size());
                    for (ConstraintViolation violation : violations) {
                        messages.add(MessageFactory.getMessage(context, MESSAGE_ID, violation.getMessage(), MessageFactory.getLabel(context, component)));
                    }
                    toThrow = new ValidatorException(messages);
                }
                if (MultiFieldValidationUtils.wholeBeanValidationEnabled(context, validationGroupsArray)) {
                    this.recordValidationResult(context, component, valueReference.getBase(), valueReference.getProperty().toString(), "jakarta.faces.Bean.FAILED_FIELD_LEVEL_VALIDATION");
                }
                throw toThrow;
            }
        }
        if (MultiFieldValidationUtils.wholeBeanValidationEnabled(context, validationGroupsArray)) {
            this.recordValidationResult(context, component, valueReference.getBase(), valueReference.getProperty().toString(), value);
        }
    }

    private static ValueReference getValueReference(FacesContext context, UIComponent component, ValueExpression valueExpression) {
        try {
            ValueExpression ve;
            Object base;
            ValueReference reference = valueExpression.getValueReference(context.getELContext());
            if (reference != null && (base = reference.getBase()) instanceof CompositeComponentExpressionHolder && (ve = ((CompositeComponentExpressionHolder)base).getExpression(String.valueOf(reference.getProperty()))) != null) {
                reference = BeanValidator.getValueReference(context, component, ve);
            }
            return reference;
        }
        catch (PropertyNotFoundException e) {
            if (component instanceof UIInput && ((UIInput)component).getSubmittedValue() == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Property of value expression {0} of component {1} could not be found, but submitted value is null in first place, so not attempting to validate", new Object[]{valueExpression.getExpressionString(), component.getId()});
                }
                return null;
            }
            throw e;
        }
    }

    private boolean isResolvable(ValueReference valueReference, ValueExpression valueExpression) {
        Boolean resolvable = null;
        Object failureMessage = null;
        if (valueExpression == null) {
            failureMessage = "Unable to validate expression using Bean Validation.  Expression must not be null.";
            resolvable = false;
        } else if (valueReference == null) {
            failureMessage = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Unable to get value of expression.";
            resolvable = false;
        } else {
            Class<?> baseClass;
            Class<?> clazz = baseClass = valueReference.getBase() == null ? null : valueReference.getBase().getClass();
            if (baseClass != null && (Map.class.isAssignableFrom(baseClass) || Collection.class.isAssignableFrom(baseClass) || Array.class.isAssignableFrom(baseClass))) {
                failureMessage = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Expression evaluates to a Map, List or array.";
                resolvable = false;
            }
        }
        resolvable = null != resolvable ? resolvable : true;
        if (!resolvable.booleanValue()) {
            LOGGER.fine((String)failureMessage);
        }
        return resolvable;
    }

    private Class<?>[] parseValidationGroups(String validationGroupsStr) {
        String[] classNames;
        if (this.cachedValidationGroups != null) {
            return this.cachedValidationGroups;
        }
        if (validationGroupsStr == null) {
            this.cachedValidationGroups = new Class[]{Default.class};
            return this.cachedValidationGroups;
        }
        ArrayList validationGroupsList = new ArrayList();
        for (String className : classNames = validationGroupsStr.split(VALIDATION_GROUPS_DELIMITER)) {
            if ((className = className.trim()).length() == 0) continue;
            if (className.equals(Default.class.getName())) {
                validationGroupsList.add(Default.class);
                continue;
            }
            try {
                validationGroupsList.add(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException e1) {
                try {
                    validationGroupsList.add(Class.forName(className));
                }
                catch (ClassNotFoundException e2) {
                    throw new FacesException("Validation group not found: " + className);
                }
            }
        }
        this.cachedValidationGroups = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        return this.cachedValidationGroups;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.validationGroups};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.validationGroups = (String)values[0];
        }
    }

    @Override
    public void markInitialState() {
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        this.initialState = false;
    }

    @Override
    public boolean isTransient() {
        return this.transientValue;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    private static jakarta.validation.Validator getBeanValidator(FacesContext context) {
        ValidatorFactory validatorFactory = BeanValidator.getValidatorFactory(context);
        ValidatorContext validatorContext = validatorFactory.usingContext();
        FacesAwareMessageInterpolator facesMessageInterpolator = new FacesAwareMessageInterpolator(context, validatorFactory.getMessageInterpolator());
        validatorContext.messageInterpolator((MessageInterpolator)facesMessageInterpolator);
        return validatorContext.getValidator();
    }

    private static ValidatorFactory getValidatorFactory(FacesContext context) {
        ValidatorFactory validatorFactory = null;
        Object cachedObject = context.getExternalContext().getApplicationMap().get(VALIDATOR_FACTORY_KEY);
        if (cachedObject instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)cachedObject;
        } else {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException e) {
                throw new FacesException("Could not build a default Bean Validator factory", e);
            }
            context.getExternalContext().getApplicationMap().put(VALIDATOR_FACTORY_KEY, validatorFactory);
        }
        return validatorFactory;
    }

    private void recordValidationResult(FacesContext context, UIComponent component, Object wholeBean, String propertyName, Object propertyValue) {
        Map<Object, Map<String, Map<String, Object>>> multiFieldCandidates = MultiFieldValidationUtils.getMultiFieldValidationCandidates(context, true);
        Map candidate = multiFieldCandidates.getOrDefault(wholeBean, new HashMap());
        HashMap<String, Object> tuple = new HashMap<String, Object>();
        tuple.put("component", component);
        tuple.put("value", propertyValue);
        candidate.put(propertyName, tuple);
        multiFieldCandidates.putIfAbsent(wholeBean, candidate);
    }

    private static class FacesAwareMessageInterpolator
    implements MessageInterpolator {
        private FacesContext context;
        private MessageInterpolator delegate;

        public FacesAwareMessageInterpolator(FacesContext context, MessageInterpolator delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            Locale locale = this.context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return this.delegate.interpolate(message, context, locale);
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(message, context, locale);
        }
    }
}

