/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Header;
import org.jgroups.protocols.PingRsp;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class PingHeader
extends Header
implements Streamable {
    public static final byte GET_MBRS_REQ = 1;
    public static final byte GET_MBRS_RSP = 2;
    public byte type = 0;
    public PingRsp arg = null;

    public PingHeader() {
    }

    public PingHeader(byte type, PingRsp arg) {
        this.type = type;
        this.arg = arg;
    }

    public long size() {
        long retval = 2L;
        if (this.arg != null) {
            retval += (long)this.arg.size();
        }
        return retval;
    }

    public String toString() {
        return "[PING: type=" + this.type2Str(this.type) + ", arg=" + this.arg + ']';
    }

    String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "GET_MBRS_REQ";
            }
            case 2: {
                return "GET_MBRS_RSP";
            }
        }
        return "<unkown type (" + t + ")>";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeObject(this.arg);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.arg = (PingRsp)in.readObject();
    }

    public void writeTo(DataOutputStream outstream) throws IOException {
        outstream.writeByte(this.type);
        Util.writeStreamable(this.arg, outstream);
    }

    public void readFrom(DataInputStream instream) throws IOException, IllegalAccessException, InstantiationException {
        this.type = instream.readByte();
        this.arg = (PingRsp)Util.readStreamable(PingRsp.class, instream);
    }
}

