/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ExtendedReceiver;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.util.Util;

public class ConcurrentStartupTest
extends TestCase
implements ExtendedReceiver {
    final List list = Collections.synchronizedList(new LinkedList());
    JChannel channel;
    static final String GROUP = "demo";
    static String PROPS = "flush-udp.xml";
    final int NUM = 5;
    int mod = 1;
    final Map modifications = new TreeMap();

    protected void setUp() throws Exception {
        super.setUp();
        PROPS = System.getProperty("props", PROPS);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMod() {
        ConcurrentStartupTest concurrentStartupTest = this;
        synchronized (concurrentStartupTest) {
            int retval = this.mod++;
            return retval;
        }
    }

    public void testMessageSendingAfterConnect() throws Exception {
        int i;
        this.channel = new JChannel(PROPS);
        this.channel.setOpt(0, Boolean.TRUE);
        this.channel.setReceiver(this);
        this.channel.connect(GROUP);
        this.channel.getState(null, 10000L);
        Util.sleep(2000L);
        MyThread[] threads = new MyThread[5];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new MyThread(String.valueOf(i));
            Util.sleepRandom(1000L);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            MyThread thread = threads[i];
            thread.join(15000L);
            if (!thread.isAlive()) continue;
            System.err.println("thread " + i + " is still alive");
        }
        List[] lists = new List[5];
        for (int i2 = 0; i2 < threads.length; ++i2) {
            MyThread thread = threads[i2];
            lists[i2] = new LinkedList(thread.getList());
        }
        this.printLists(this.list, lists);
        Map[] mods = new Map[5];
        for (int i3 = 0; i3 < threads.length; ++i3) {
            MyThread thread = threads[i3];
            mods[i3] = thread.getModifications();
        }
        this.printModifications(this.modifications, mods);
        int len = this.list.size();
        for (int i4 = 0; i4 < lists.length; ++i4) {
            List l = lists[i4];
            ConcurrentStartupTest.assertEquals((String)("list #" + i4 + " should have " + len + " elements"), (int)len, (int)l.size());
        }
    }

    private void printModifications(Map mod, Map[] modifications) {
        System.out.println("\nmodifications: " + mod);
        for (int i = 0; i < modifications.length; ++i) {
            Map modification = modifications[i];
            System.out.println("modifications for #" + i + ": " + modification);
        }
    }

    private void printLists(List list, List[] lists) {
        System.out.println("\nlist=" + list);
        for (int i = 0; i < lists.length; ++i) {
            List l = lists[i];
            System.out.println(i + ": " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message msg) {
        if (msg.getBuffer() == null) {
            return;
        }
        Object obj = msg.getObject();
        ConcurrentStartupTest concurrentStartupTest = this;
        synchronized (concurrentStartupTest) {
            this.list.add(obj);
            Integer key = new Integer(this.getMod());
            this.modifications.put(key, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getState() {
        ConcurrentStartupTest concurrentStartupTest = this;
        synchronized (concurrentStartupTest) {
            LinkedList tmp = new LinkedList(this.list);
            try {
                return Util.objectToByteBuffer(tmp);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(byte[] state) {
        try {
            List tmp = (List)Util.objectFromByteBuffer(state);
            ConcurrentStartupTest concurrentStartupTest = this;
            synchronized (concurrentStartupTest) {
                this.list.clear();
                this.list.addAll(tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getState(String state_id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream ostream) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(ostream);
            LinkedList tmp = null;
            ConcurrentStartupTest concurrentStartupTest = this;
            synchronized (concurrentStartupTest) {
                tmp = new LinkedList(this.list);
            }
            oos.writeObject(tmp);
            oos.flush();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Util.close(oos);
                throw throwable;
            }
            Util.close(oos);
        }
        Util.close(oos);
    }

    public void getState(String state_id, OutputStream ostream) {
    }

    public void setState(String state_id, byte[] state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream istream) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(istream);
            List tmp = (List)ois.readObject();
            ConcurrentStartupTest concurrentStartupTest = this;
            synchronized (concurrentStartupTest) {
                this.list.clear();
                this.list.addAll(tmp);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Util.close(ois);
                throw throwable;
            }
            Util.close(ois);
        }
        Util.close(ois);
    }

    public void setState(String state_id, InputStream istream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View new_view) {
        System.out.println("-- view: " + new_view);
        ConcurrentStartupTest concurrentStartupTest = this;
        synchronized (concurrentStartupTest) {
            Integer key = new Integer(this.getMod());
            this.modifications.put(key, new_view.getVid());
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void unblock() {
    }

    public static Test suite() {
        return new TestSuite(ConcurrentStartupTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConcurrentStartupTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class MyThread
    extends Thread {
        final List list = new LinkedList();
        Channel ch;
        int mod = 1;
        final Map modifications = new TreeMap();

        int getMod() {
            int retval = this.mod++;
            return retval;
        }

        MyThread(String name) {
            super(name);
        }

        public void run() {
            try {
                this.ch = new JChannel(PROPS);
                this.ch.setOpt(0, Boolean.TRUE);
                this.ch.setReceiver(new ExtendedReceiverAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void receive(Message msg) {
                        if (msg.getBuffer() == null) {
                            return;
                        }
                        Object obj = msg.getObject();
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            MyThread.this.list.add(obj);
                            Integer key = new Integer(MyThread.this.getMod());
                            MyThread.this.modifications.put(key, obj);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void viewAccepted(View new_view) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            Integer key = new Integer(MyThread.this.getMod());
                            MyThread.this.modifications.put(key, new_view.getVid());
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void setState(byte[] state) {
                        try {
                            List tmp = (List)Util.objectFromByteBuffer(state);
                            1 var3_4 = this;
                            synchronized (var3_4) {
                                MyThread.this.list.clear();
                                MyThread.this.list.addAll(tmp);
                                System.out.println("-- [#" + MyThread.this.getName() + " (" + MyThread.this.ch.getLocalAddress() + ")]: state is " + MyThread.this.list);
                                Integer key = new Integer(MyThread.this.getMod());
                                MyThread.this.modifications.put(key, tmp);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public byte[] getState() {
                        LinkedList tmp = null;
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            tmp = new LinkedList(MyThread.this.list);
                            try {
                                return Util.objectToByteBuffer(tmp);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return null;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void getState(OutputStream ostream) {
                        ObjectOutputStream oos = null;
                        try {
                            oos = new ObjectOutputStream(ostream);
                            LinkedList tmp = null;
                            1 var4_5 = this;
                            synchronized (var4_5) {
                                tmp = new LinkedList(MyThread.this.list);
                            }
                            oos.writeObject(tmp);
                            oos.flush();
                        }
                        catch (IOException e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                Util.close(oos);
                                throw throwable;
                            }
                            Util.close(oos);
                        }
                        Util.close(oos);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void setState(InputStream istream) {
                        ObjectInputStream ois = null;
                        try {
                            ois = new ObjectInputStream(istream);
                            List tmp = (List)ois.readObject();
                            1 var4_5 = this;
                            synchronized (var4_5) {
                                MyThread.this.list.clear();
                                MyThread.this.list.addAll(tmp);
                                System.out.println("-- [#" + MyThread.this.getName() + " (" + MyThread.this.ch.getLocalAddress() + ")]: state is " + MyThread.this.list);
                                Integer key = new Integer(MyThread.this.getMod());
                                MyThread.this.modifications.put(key, tmp);
                            }
                        }
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                Util.close(ois);
                                throw throwable;
                            }
                            Util.close(ois);
                        }
                        Util.close(ois);
                    }
                });
                this.ch.connect(ConcurrentStartupTest.GROUP);
                this.ch.getState(null, 10000L);
                this.ch.send(null, null, this.ch.getLocalAddress());
                Util.sleep(10000L);
            }
            catch (ChannelException e) {
                e.printStackTrace();
            }
        }

        List getList() {
            return this.list;
        }

        Map getModifications() {
            return this.modifications;
        }
    }
}

