/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class FixedMembershipToken
extends AuthToken {
    private static final String FIXED_MEMBERS_ATTR = "fixed_members_value";
    private static final String FIXED_MEMBERS_SEPERATOR_ATTR = "fixed_members_seperator";
    private List memberList = null;
    private String token = "emptyToken";

    public String getName() {
        return "org.jgroups.auth.FixedMembershipToken";
    }

    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof FixedMembershipToken && this.memberList != null) {
            FixedMembershipToken serverToken = (FixedMembershipToken)token;
            String sourceAddressWithPort = msg.getSrc().toString();
            String sourceAddressWithoutPort = sourceAddressWithPort.substring(0, sourceAddressWithPort.indexOf(":"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("AUTHToken received from " + sourceAddressWithPort));
            }
            if (this.memberList.contains(sourceAddressWithPort) || this.memberList.contains(sourceAddressWithoutPort)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"FixedMembershipToken match");
                }
                return true;
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Authentication failed on FixedMembershipToken");
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)"Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    public void setValue(Properties properties) {
        this.memberList = new ArrayList();
        StringTokenizer memberListTokenizer = new StringTokenizer((String)properties.get(FIXED_MEMBERS_ATTR), (String)properties.get(FIXED_MEMBERS_SEPERATOR_ATTR));
        while (memberListTokenizer.hasMoreTokens()) {
            this.memberList.add(memberListTokenizer.nextToken().replace('/', ':'));
        }
        properties.remove(FIXED_MEMBERS_ATTR);
        properties.remove(FIXED_MEMBERS_SEPERATOR_ATTR);
    }

    public void writeTo(DataOutputStream out) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"SimpleToken writeTo()");
        }
        Util.writeString(this.token, out);
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"SimpleToken readFrom()");
        }
        this.token = Util.readString(in);
    }
}

