/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Distributions;

import arjuna.JavaSim.Distributions.RandomStream;
import java.io.IOException;

public class ErlangStream
extends RandomStream {
    private double Mean;
    private double StandardDeviation;
    private long k;

    public ErlangStream(double m, double sd) {
        this.Mean = m;
        this.StandardDeviation = sd;
        double z = this.Mean / this.StandardDeviation;
        this.k = (long)(z * z);
    }

    public ErlangStream(double m, double sd, int StreamSelect) {
        this.Mean = m;
        this.StandardDeviation = sd;
        double z = this.Mean / this.StandardDeviation;
        this.k = (long)(z * z);
        for (int ss = 0; ss < StreamSelect * 1000; ++ss) {
            this.Uniform();
        }
    }

    public ErlangStream(double m, double sd, int StreamSelect, long MGSeed, long LCGSeed) {
        super(MGSeed, LCGSeed);
        this.Mean = m;
        this.StandardDeviation = sd;
        double z = this.Mean / this.StandardDeviation;
        this.k = (long)(z * z);
        for (int ss = 0; ss < StreamSelect * 1000; ++ss) {
            this.Uniform();
        }
    }

    public double getNumber() throws IOException, ArithmeticException {
        double z = 1.0;
        int i = 0;
        while ((long)i < this.k) {
            z *= this.Uniform();
            ++i;
        }
        return -(this.Mean / (double)this.k) * Math.log(z);
    }
}

