/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Distributions;

import java.io.IOException;

public abstract class RandomStream {
    private long MSeed;
    private long LSeed;
    private double[] series = new double[128];
    private static final long sizeOfSeries = 1024L;
    private static final long sizeOfDouble = 8L;

    public abstract double getNumber() throws IOException, ArithmeticException;

    public final double Error() {
        long r = 100L;
        long N = 100L * r;
        long[] f = new long[100];
        int i = 0;
        while ((long)i < r) {
            f[i] = 0L;
            ++i;
        }
        i = 0;
        while ((long)i < N) {
            int n = (int)(this.Uniform() * (double)r);
            f[n] = f[n] + 1L;
            ++i;
        }
        long t = 0L;
        i = 0;
        while ((long)i < r) {
            t += f[i] * f[i];
            ++i;
        }
        double rt = (double)r * (double)t;
        double rtN = rt / (double)N - (double)N;
        return 1.0 - rtN / (double)r;
    }

    protected RandomStream() {
        this.MSeed = 772531L;
        this.LSeed = 1878892440L;
        int i = 0;
        while ((long)i < 128L) {
            this.series[i] = this.MGen();
            ++i;
        }
    }

    protected RandomStream(long MGSeed, long LCGSeed) {
        if ((MGSeed & 1L) == 0L) {
            --MGSeed;
        }
        if (MGSeed < 0L) {
            MGSeed = -MGSeed;
        }
        if (LCGSeed < 0L) {
            LCGSeed = -LCGSeed;
        }
        this.MSeed = MGSeed;
        this.LSeed = LCGSeed;
        int i = 0;
        while ((long)i < 128L) {
            this.series[i] = this.MGen();
            ++i;
        }
    }

    protected final double Uniform() {
        long m = 100000000L;
        long b = 31415821L;
        long m1 = 10000L;
        long p0 = this.LSeed % m1;
        long p1 = this.LSeed / m1;
        long q0 = b % m1;
        long q1 = b / m1;
        this.LSeed = (((p0 * q1 + p1 * q0) % m1 * m1 + p0 * q0) % m + 1L) % m;
        long choose = this.LSeed % 128L;
        double result = this.series[(int)choose];
        this.series[(int)choose] = this.MGen();
        return result;
    }

    private double MGen() {
        long two2the26th = 0x4000000L;
        this.MSeed = this.MSeed * 25L % two2the26th;
        this.MSeed = this.MSeed * 25L % two2the26th;
        this.MSeed = this.MSeed * 5L % two2the26th;
        return (double)this.MSeed / (double)two2the26th;
    }
}

