/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Simulation;

import arjuna.JavaSim.Simulation.RestartException;
import arjuna.JavaSim.Simulation.SimulationEntity;
import arjuna.JavaSim.Simulation.SimulationException;
import arjuna.JavaSim.Simulation.TriggerQueue;

public class Semaphore {
    private TriggerQueue waitingList;
    private long numberWaiting = 0L;
    private long numberOfResources;
    private long currentResources;

    public Semaphore() {
        this.numberOfResources = 1L;
        this.currentResources = 1L;
    }

    public Semaphore(long number) {
        this.numberOfResources = number;
        this.currentResources = number;
    }

    public void finalize() {
        if (this.numberWaiting != 0L) {
            System.out.println("Warning: semaphore being removed with clients waiting.");
        }
    }

    public synchronized long NumberWaiting() {
        return this.numberWaiting;
    }

    public synchronized int Get(SimulationEntity toWait) throws RestartException {
        if (this.currentResources > 0L) {
            --this.currentResources;
        } else {
            ++this.numberWaiting;
            try {
                this.waitingList.insert(toWait);
            }
            catch (SimulationException simulationException) {
                // empty catch block
            }
            toWait.Cancel();
        }
        return 0;
    }

    public synchronized int TryGet(SimulationEntity toWait) throws RestartException {
        if (this.currentResources == 0L) {
            return 2;
        }
        return this.Get(toWait);
    }

    public synchronized int Release() {
        if (this.numberWaiting > 0L) {
            ++this.currentResources;
            if (this.currentResources > this.numberOfResources) {
                this.currentResources = this.numberOfResources;
            }
            --this.numberWaiting;
            this.waitingList.triggerFirst(false);
            return 0;
        }
        return 1;
    }
}

