/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Simulation;

import arjuna.JavaSim.Simulation.SimulationProcess;
import arjuna.JavaSim.Simulation.SimulationProcessCons;
import arjuna.JavaSim.Simulation.SimulationProcessIterator;
import java.util.NoSuchElementException;

public class SimulationProcessList {
    protected SimulationProcessCons Head = null;

    public synchronized void Insert(SimulationProcess p) {
        this.Insert(p, false);
    }

    public synchronized void Insert(SimulationProcess p, boolean prior) {
        if (this.Head == null) {
            this.Head = new SimulationProcessCons(p, null);
            return;
        }
        SimulationProcessIterator iter = new SimulationProcessIterator(this);
        SimulationProcess prev = null;
        SimulationProcess q = iter.get();
        while (q != null) {
            if (prior) {
                if (q.evtime() >= p.evtime()) {
                    this.InsertBefore(p, q);
                    return;
                }
            } else if (q.evtime() > p.evtime()) {
                this.InsertBefore(p, q);
                return;
            }
            prev = q;
            q = iter.get();
        }
        this.InsertAfter(p, prev);
    }

    public synchronized boolean InsertBefore(SimulationProcess ToInsert, SimulationProcess Before) {
        SimulationProcessCons prev = null;
        for (SimulationProcessCons p = this.Head; p != null; p = p.cdr()) {
            if (p.car() == Before) {
                SimulationProcessCons newcons = new SimulationProcessCons(ToInsert, p);
                if (prev != null) {
                    prev.SetfCdr(newcons);
                } else {
                    this.Head = newcons;
                }
                return true;
            }
            prev = p;
        }
        return false;
    }

    public synchronized boolean InsertAfter(SimulationProcess ToInsert, SimulationProcess After) {
        for (SimulationProcessCons p = this.Head; p != null; p = p.cdr()) {
            if (p.car() != After) continue;
            SimulationProcessCons newcons = new SimulationProcessCons(ToInsert, p.cdr());
            p.SetfCdr(newcons);
            return true;
        }
        return false;
    }

    public synchronized SimulationProcess Remove(SimulationProcess element) throws NoSuchElementException {
        if (this.Head == null) {
            throw new NoSuchElementException();
        }
        SimulationProcess p = null;
        SimulationProcessCons prev = null;
        for (SimulationProcessCons ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            if (ptr.car() == element) {
                SimulationProcessCons oldcons = ptr;
                if (prev != null) {
                    prev.SetfCdr(ptr.cdr());
                } else {
                    this.Head = ptr.cdr();
                }
                p = ptr.car();
                return p;
            }
            prev = ptr;
        }
        throw new NoSuchElementException();
    }

    public synchronized SimulationProcess Remove() throws NoSuchElementException {
        if (this.Head != null) {
            return this.Remove(this.Head.car());
        }
        throw new NoSuchElementException();
    }

    public synchronized SimulationProcess getNext(SimulationProcess current) throws NoSuchElementException {
        if (this.Head == null || current == null) {
            throw new NoSuchElementException();
        }
        for (SimulationProcessCons ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            if (ptr.car() == current) {
                if (ptr.cdr() == null) {
                    return null;
                }
                return ptr.cdr().car();
            }
            if (ptr.car().evtime() > current.evtime()) break;
        }
        return this.Head.car();
    }

    public void print() {
        SimulationProcessIterator iter = new SimulationProcessIterator(this);
        SimulationProcess prev = null;
        SimulationProcess q = iter.get();
        while (q != null) {
            System.out.println(q.evtime());
            prev = q;
            q = iter.get();
        }
    }
}

