/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Statistics;

import arjuna.JavaSim.Statistics.Bucket;
import arjuna.JavaSim.Statistics.StatisticsException;
import arjuna.JavaSim.Statistics.Variance;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class PrecisionHistogram
extends Variance {
    protected long length = 0L;
    protected Bucket Head = null;

    public PrecisionHistogram() {
        this.reset();
    }

    public void finalize() {
        this.reset();
    }

    public void setValue(double value) throws IllegalArgumentException {
        super.setValue(value);
        Bucket trail = null;
        for (Bucket ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            if (ptr.Name() == value) {
                ptr.incrementSize(1L);
                return;
            }
            if (ptr.greaterThan(value)) break;
            trail = ptr;
        }
        this.add(trail, value, false);
    }

    public void reset() {
        if (this.length > 0L) {
            Bucket trail = this.Head;
            for (long i = 0L; i < this.length; ++i) {
                trail = this.Head = this.Head.cdr();
            }
            this.length = 0L;
            this.Head = null;
        }
        super.reset();
    }

    public long numberOfBuckets() {
        return this.length;
    }

    public double sizeByIndex(long index) throws StatisticsException, IllegalArgumentException {
        Bucket ptr = this.Head;
        if (index < 0L || index > this.length) {
            throw new IllegalArgumentException("index out of range.");
        }
        for (long i = 0L; i < index && ptr != null; ptr = ptr.cdr(), ++i) {
        }
        if (ptr != null) {
            return ptr.size();
        }
        throw new StatisticsException("sizeByIndex went off end of list.");
    }

    public double sizeByName(double name) throws IllegalArgumentException {
        for (Bucket ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            if (ptr.Name() == name) {
                return ptr.size();
            }
            if (ptr.greaterThan(name)) break;
        }
        throw new IllegalArgumentException("Bucket name " + name + " not found.");
    }

    public boolean saveState(String fileName) throws IOException {
        FileOutputStream f = new FileOutputStream(fileName);
        DataOutputStream oFile = new DataOutputStream(f);
        boolean res = this.saveState(oFile);
        f.close();
        return res;
    }

    public boolean saveState(DataOutputStream oFile) throws IOException {
        oFile.writeLong(this.length);
        for (Bucket ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            oFile.writeDouble(ptr.Name());
            oFile.writeLong(ptr.size());
        }
        return super.saveState(oFile);
    }

    public boolean restoreState(String fileName) throws FileNotFoundException, IOException {
        FileInputStream f = new FileInputStream(fileName);
        DataInputStream iFile = new DataInputStream(f);
        boolean res = this.restoreState(iFile);
        f.close();
        return res;
    }

    public boolean restoreState(DataInputStream iFile) throws IOException {
        Bucket ptr = null;
        this.reset();
        this.length = iFile.readLong();
        int i = 0;
        while ((long)i < this.length) {
            double bucketName = iFile.readDouble();
            long numberEntries = iFile.readLong();
            Bucket toAdd = new Bucket(bucketName, numberEntries);
            if (this.Head != null) {
                ptr.setCdr(toAdd);
            } else {
                this.Head = toAdd;
            }
            ptr = toAdd;
            ++i;
        }
        return super.restoreState(iFile);
    }

    public void print() {
        if (this.length == 0L) {
            System.out.println("Empty histogram.");
        } else {
            for (Bucket ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
                System.out.println("Bucket : < " + ptr.Name() + ", " + ptr.size() + " >");
            }
        }
        super.print();
    }

    protected boolean isPresent(double value) {
        try {
            double dummy = this.sizeByName(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected void create(double value) {
        Bucket trail = null;
        for (Bucket ptr = this.Head; ptr != null; ptr = ptr.cdr()) {
            if (ptr.Name() == value) {
                return;
            }
            if (ptr.greaterThan(value)) break;
            trail = ptr;
        }
        this.add(trail, value, true);
    }

    private void add(Bucket addPosition, double value, boolean createOnly) {
        long initEntries = createOnly ? 0L : 1L;
        Bucket newBucket = new Bucket(value, initEntries);
        if (addPosition == null) {
            newBucket.setCdr(this.Head);
            this.Head = newBucket;
        } else {
            newBucket.setCdr(addPosition.cdr());
            addPosition.setCdr(newBucket);
        }
        ++this.length;
    }
}

